\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{beamer}
[2003/09/19 v0.6 Class for Typesetting a Beamer Presentation]

% Copyright 2003 by Till Tantau <tantau@cs.tu-berlin.de>.
%
% This program can be redistributed and/or modified under the terms
% of the LaTeX Project Public License Distributed from CTAN
% archives in directory macros/latex/base/lppl.txt.

\RequirePackage{pgf,color,amssymb}

\RequirePackage[papersize={12.80cm,9.60cm}]{geometry}

\ifx\ifGm@compatii\@undefined\else\geometry{includeheadfoot}\fi

\RequirePackage[implicit=false,%
  bookmarks=true,%
  bookmarksopen=true,%
  pdfborder={0 0 0},%
  pdfhighlight={/N}]{hyperref}

% Un-implict fixes for hyperref
\def\WriteBookmarks{0}
\expandafter\def\csname Parent-1\endcsname{}
\expandafter\def\csname Parent0\endcsname{}
\def\phantomsection{}

\newif\if@altmode
\@altmodefalse
\newif\if@notes
\@notesfalse
\newif\if@notesnormals
\@notesnormalstrue

\newif\ifsubsectionrows
\newif\ifsubsectionshide
\newif\ifsubsectionsshaded
\subsectionrowsfalse
\subsectionshidefalse
\subsectionsshadedfalse

\DeclareOption{hidesubsections}
{\subsectionshidetrue}

\DeclareOption{shadesubsections}
{\subsectionsshadedtrue}

\DeclareOption{inrow}
{\subsectionrowstrue}

\DeclareOption{blue}
{\themecolor{0.2}{0.2}{0.7}}

\DeclareOption{red}
{\themecolor{0.7}{0.2}{0.2}}

\DeclareOption{grey}
{\themecolor{0.2}{0.2}{0.2}}

\DeclareOption{brown}
{\themecolor{0.66}{0.4}{0.166}}

\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}

%\setlength\paperheight {90.0mm}%
%\setlength\paperwidth  {115.2mm}

\def\@currentmode{default}
\DeclareOption{handout}{\gdef\@currentmode{handout}}
\DeclareOption{trans}{\gdef\@currentmode{trans}}

\DeclareOption{notes}{\@notestrue}
\DeclareOption{notesonly}{\@notestrue\@notesnormalsfalse}

% Hyperlinks must be suspended until document starts - they are used
% inside \usetemplate commands before the beginning of the document,
% but there we do not want them to have an effect.
\let\suspendedhyperlink\hyperlink
\def\hyperlink#1#2{#2}
\AtBeginDocument{%
  \if@notesnormals\let\hyperlink\suspendedhyperlink\fi%
  }
\let\@origdocument\document
\def\document{\recalculatefoot\recalculatehead\@origdocument}

%\ifprintout
%\definecolor{alert}{gray}{0}
%\definecolor{darkgreen}{gray}{0}
%\definecolor{shaded}{gray}{0.75}
%\definecolor{structure}{gray}{0}
%\definecolor{structureshaded}{gray}{0.75}
%\definecolor{structuremedium}{gray}{0.3}
%\definecolor{lightgray}{gray}{0.9}
%\else
\definecolor{alert}{rgb}{1,0,0}
\definecolor{darkgreen}{rgb}{0.15,0.6,0.15}
\definecolor{shaded}{gray}{0.6}
\definecolor{blockstructure}{rgb}{0.2,0.2,0.7}
\definecolor{lightgray}{gray}{0.9}

\def\themecolor#1#2#3{
  \definecolor{structure}{rgb}{#1,#2,#3}
  \edef\thethemecolor{#1,#2,#3}
  \pgf@ya=1pt
  \advance\pgf@ya by-#1pt%
  \pgf@ya=.4\pgf@ya%
  \pgf@x=1pt%
  \advance\pgf@x by-\pgf@ya%
  \pgf@ya=1pt
  \advance\pgf@ya by-#2pt%
  \pgf@ya=.4\pgf@ya%
  \pgf@y=1pt%
  \advance\pgf@y by-\pgf@ya%
  \pgf@ya=1pt
  \advance\pgf@ya by-#3pt%
  \pgf@ya=.4\pgf@ya%
  \pgf@xa=1pt%
  \advance\pgf@xa by-\pgf@ya%
  \definecolor{structureshaded}{rgb}{\pgfget{x},\pgfget{y},\pgfget{xa}}
  \edef\theshadedthemecolor{\pgfget{x},\pgfget{y},\pgfget{xa}}
  \pgf@ya=1pt
  \advance\pgf@ya by-#1pt%
  \pgf@ya=.7\pgf@ya%
  \pgf@x=1pt%
  \advance\pgf@x by-\pgf@ya%
  \pgf@ya=1pt
  \advance\pgf@ya by-#2pt%
  \pgf@ya=.7\pgf@ya%
  \pgf@y=1pt%
  \advance\pgf@y by-\pgf@ya%
  \pgf@ya=1pt
  \advance\pgf@ya by-#3pt%
  \pgf@ya=.7\pgf@ya%
  \pgf@xa=1pt%
  \advance\pgf@xa by-\pgf@ya%
  \definecolor{structuremedium}{rgb}{\pgfget{x},\pgfget{y},\pgfget{xa}}
  }
\themecolor{0.2}{0.2}{0.7}

\ProcessOptions
\input{size11.clo}

% Calculate number of sections/subsections
\newcount\subsection@max
\newcount\section@max
\subsection@max=0\relax
\section@max=0\relax

\newcount\totalheads
\def\headcommand#1{\advance\totalheads by1\relax\expandafter\def\csname
  head\the\totalheads\endcsname{#1}}
\@input{\jobname.head}
\newcount\headcounter
\def\dohead{\headcounter=0\loop\ifnum\headcounter<\totalheads%
  \advance\headcounter by1\relax%
  \csname head\the\headcounter\endcsname\repeat}

\def\sectionentry#1#2#3#4{\ifnum\section@max<#1\relax\section@max=#1\fi}
\def\slideentry#1#2#3#4#5{\ifnum\subsection@max<#2\relax\subsection@max=#2\fi}
\dohead

\geometry{hmargin=1cm,vmargin=0cm,%
  head=0.5cm,headsep=0pt,%
  foot=0.5cm}


\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}

\setlength\parskip{0\p@}% \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.9}%.2}
\renewcommand\floatpagefraction{.1}%5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\setlength\leftmargini  {2em}
\setlength\leftmarginii  {2em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty

\setcounter{tocdepth}{2}

\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@arabic\c@enumii}

\def\@listi{\leftmargin\leftmargini
            \topsep 4\p@ \@plus2\p@ \@minus\p@
            \parsep 0\p@
            \itemsep4\p@ \@plus2\p@ \@minus2\p@}
\let\@listI\@listi
\def\@listii {\leftmargin\leftmarginii
              \topsep    2\p@ \@plus2\p@ \@minus\p@
              \parsep    0\p@   \@plus\p@  \@minus\p@
              \itemsep   \parsep}

\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}


% Bugfix of latex internals

\def\smallskip{\vskip\smallskipamount}
\def\medskip{\vskip\medskipamount}
\def\bigskip{\vskip\bigskipamount}

\newcommand\titlepage
{{\@titlepagetemplate}}


\renewcommand\title[1]{\def\inserttitletitle{#1}%
  \def\inserttitle{\def\\{}%
    \hyperlink{Navigation1}{#1}}}
\title{}

\renewcommand\date[1]{\def\insertdate{#1}}
\date{\today}

\def\insttitle#1{$^{#1}$}
\def\andtitle{\quad}
\def\instother#1{}
\def\andother{\unskip, }

\def\author#1{\def\insertauthortitle{\def\inst{\insttitle}\def\and{\andtitle}#1}%
  \def\insertauthor{\def\inst{\instother}\def\and{\andother}#1}}
\author{}

\newcommand\titlegraphic[1]{\def\inserttitlegraphic{#1}}
\titlegraphic{}

\def\instinst#1{$^{#1}$\ignorespaces}
\def\andinst{\\[1em]}
\newcommand\institute[1]{\def\insertinstitute{\def\inst{\instinst}\def\and{\andinst}#1}}
\institute{}

\newcommand\instituteshort[1]{\def\insertinstituteshort{#1}}
\instituteshort{}

%\newcommand\date[1]{\def\@date{#1}}
%\date{\today}

\newcommand\kindoftalk[1]{\def\insertkindoftalk{#1}}
\kindoftalk{Vortrag zum Thema}


\newcommand\logo[1]{\def\insertlogo{#1}}
\logo{}

\long\def\usetitlepagetemplate#1{\def\@titlepagetemplate{#1}}


%
% Section Definitions
%

\def\@isempty{}
\long\def\@ifempty#1#2#3{\def\@shouldbeempty{#1}\ifx\@shouldbeempty\@isempty#2\else#3\fi}

\def\sectionname{Section}

\newcounter{section}
\renewcommand\thesection{\@arabic\c@section}

\def\section{\@ifnextchar[\@section\@@section}

\long\def\@@section#1{\@section[#1]{#1}}
\long\def\@section[#1]#2{%
  \refstepcounter{section}%
  \@ifempty{#2}{\long\def\secname{#1}}{\long\def\secname{#2}\addtocontents{toc}{\protect\sectionintoc{\thesection}{#2}{\thepage}}}%
  \addtocontents{head}{\protect\headcommand{\protect\sectionentry{\thesection}{#1}{\thepage}{\secname}}}%
  {\let\\=\relax\xdef\sectionlink{{Navigation\thepage}{\secname}}}%
  \def\insertsection{\expandafter\hyperlink\sectionlink}%
  \def\insertsubsection{}%
  \def\lastsubsection{}%
  \Hy@writebookmark{\thesection}{\secname}{Outline\thesection}{1}{toc}%
  \hyper@anchorstart{Outline\thesection}\hyper@anchorend}%
\def\insertsection{}
\def\lastsubsection{}

\def\breakhere{\protect\@breakhere}
\def\@breakhere{}

%
% Subsection Definitions
%

\newcounter{subsection}[section]
\renewcommand\thesubsection{\@arabic\c@subsection}

\def\subsection#1{%
  \ifsubsectionrows\ifnum0=\c@subsection\refstepcounter{subsection}\fi%
  \else\refstepcounter{subsection}\fi%
  \addtocontents{toc}{\protect\subsectionintoc{\thesection}{\thesubsection}{#1}{\thepage}}%
  \def\lastsubsection{#1}%
  \edef\subsectionlink{{Navigation\thepage}{#1}}%
  \def\insertsubsection{\expandafter\hyperlink\subsectionlink}
  \Hy@writebookmark{\thesubsection}{#1}{Outline\thesection.\thesubsection.\thepage}{2}{toc}%
  \hyper@anchorstart{Outline\thesection.\thesubsection.\thepage}\hyper@anchorend}


\def\untitledsubsection{%
  \ifsubsectionrows\ifnum0=\c@subsection\refstepcounter{subsection}\fi%
  \else\refstepcounter{subsection}\fi%
  \def\insertsubsection{}%
  \def\lastsubsection{}}
\def\insertsubsection{}


%
% Slide Definitions
%

\newcounter{subsectionslide}[subsection]
\renewcommand\thesubsectionslide{\@arabic\c@subsectionslide}

\newenvironment{frameslide}[1][1]{%
  \serialnumber=#1\relax%
  \ifnum\serialnumber=1\relax%
  \refstepcounter{subsectionslide}%
  \addtocontents{head}{\protect\headcommand{\protect\slideentry{\thesection}{\thesubsection}{\thesubsectionslide}{\thepage}{\lastsubsection}}}%
  \fi\vspace*{-\baselineskip}\vfill}%
  {\vskip0pt plus 1.5fill\clearpage}

\def\frametitle#1{%
  \vskip0pt plus -1fill%
  {\gdef\insertframetitle{#1\par}\@headrenderer}
  \vskip0.25em%
  \vfill%
}

\long\def\useframetitletemplate#1{\def\@headrenderer{#1}}



%
%
% Overlaying
%
%

\let\origverb@egroup=\verb@egroup

\def\@setb{\setbox0=\copy}
\long\def\defverb#1{%
  \expandafter\newbox\csname @verb\string#1\endcsname%
  \def#1{{\expandafter\@setb\csname
      @verb\string#1\endcsname\unhbox0}}%
  \def\verb@egroup{\global\let\verb@balance@group\@empty\egroup\egroup\let\verb@egroup=\origverb@egroup}
  \expandafter\setbox\csname @verb\string#1\endcsname=\hbox\bgroup
  \verb}


\long\def\defverbatim#1{%
  \expandafter\newbox\csname @verb\string#1\endcsname%
  \def#1{{\expandafter\@setb\csname @verb\string#1\endcsname\unvbox0}}%
  \expandafter\setbox\csname @verb\string#1\endcsname=\vbox\bgroup
  \def\set@color{}\def\reset@color{}\let\@next=}

\long\def\alt<#1>#2#3{%
  \def\dowhat{#3}\def\doit{#2}%
  {\setbox0=\hbox{\decode#1| stop:| }}\dowhat}

\def\original#1{\csname @orig\string#1\endcsname}

\long\def\newoverlaycommand#1#2#3{% In slides, #1 does #2, otherwise #3
  \def#1{\@ifnextchar<{\@overlayparse{#2}{#3}}{#2}}}

\long\def\renewoverlaycommand#1#2#3{% In slides, #1 does #2, otherwise #3
  \edef\@name{\original#1}
  \expandafter\let\@name=#1\relax%
  \def#1{\@ifnextchar<{\@overlayparse{#2}{#3}}{#2}}}

\long\def\@overlayparse#1#2<#3>{\alt<#3>{#1}{#2}}

\def\newoverlayenvironment#1{%
  \@ifnextchar[{\@@newoverlayenvironment{#1}}{\@newoverlayenvironment{#1}}}

\long\def\@newoverlayenvironment#1#2#3#4#5{% In slides, #1 forms an
% environment with begin #2 and end #3, otherwise an environment with 
% begin #4 and end #5
  \newenvironment{#1}{}{}%
  \expandafter\def\csname #1\endcsname{%
    \@ifnextchar<{\@parsebegin{#1}{#2}{#3}{#4}{#5}}{%
      \expandafter\def\csname end#1\endcsname{#3}#2}}%
  }
    
\long\def\@parsebegin#1#2#3#4#5<#6>{%
  \alt<#6>{% In slide case
    \expandafter\def\csname end#1\endcsname{#3}%
    #2}{%
    \expandafter\def\csname end#1\endcsname{#5}%
    #4}}

\long\def\renewoverlayenvironment#1#2#3#4#5{%
  \edef\@do{\csname original#1\endcsname=\expandafter\noexpand\csname#1\endcsname}
  \expandafter\let\@do
  \edef\@do{\csname endoriginal#1\endcsname=\expandafter\noexpand\csname end#1\endcsname}
  \expandafter\let\@do
  \renewenvironment{#1}{}{}%
  \expandafter\def\csname #1\endcsname{%
    \@ifnextchar<{\@parsebegin{#1}{#2}{#3}{#4}{#5}}{%
      \expandafter\def\csname end#1\endcsname{#3}#2}%
    }%
  }

\long\def\@@newoverlayenvironment#1[1]#2#3#4#5{% Currently, this works
% only for a single argument
  \newenvironment{#1}{}{}%
  \expandafter\new@command\csname @in#1\endcsname[1]{#2}%
  \expandafter\new@command\csname @out#1\endcsname[1]{#4}%
  \expandafter\def\csname #1\endcsname##1{%
    \@ifnextchar<{\@parsebegin{#1}{\csname @in#1\endcsname{##1}}{#3}{\csname @out#1\endcsname{##1}}{#5}}{%
      \expandafter\def\csname end#1\endcsname{#3}#2}}%
  }


%
% Make item overlays
%

\let\@origitem=\item
\def\item{%
  \@closeitem\gdef\@closeitem{}%
  \@ifnextchar<{\@parseitem}{\@origitem}}
\def\@closeitem{}
\def\@parseitem<#1>{%
  \alt<#1>{\pgfsys@begininvisible\pgfsys@endinvisible%for spacing reasons
    \gdef\@closeitem{\pgfsys@begininvisible\pgfsys@endinvisible}\@origitem}%
  {\pgfsys@begininvisible\gdef\@closeitem{\pgfsys@endinvisible}\@origitem}%
  }

\let\@origendtrivlist=\endtrivlist
\def\endtrivlist{\@closeitem\global\let\@closeitem=\@sci\global\let\@sci=\@ssci\global\let\@ssci=\@sssci\@origendtrivlist}
\let\@orig@trivlist=\@trivlist
\def\@trivlist{\global\let\@sssci=\@ssci\global\let\@ssci=\@sci\global\let\@sci=\@closeitem\gdef\@closeitem{}\@orig@trivlist}
\def\@closeitem{}

\newcount\serialnumber
\newcount\@serialnumber
\newcount\maxserialnumber

\newif\if@anotherslide

\def\frame{\@ifnextchar[{\@frame}{\@frame[+]}}
\def\@frame[#1]{%
  \gdef\insertframetitle{}%
  \gdef\@whichframes{#1}%
  \serialnumber=0\relax%
  \@anotherslidefalse%
  {\setbox0=\hbox{\expandafter\decode\@whichframes| stop:| }}%
  \if@anotherslide%
  \serialnumber=2\relax%
  \def\dowhat{}%
  \def\doit{\let\howtotreatframe\doseveralframes}%
  \@anotherslidefalse%
  {\setbox0=\hbox{\expandafter\decode\@whichframes| stop:| }}%
  \if@anotherslide%
  \let\howtotreatframe\doseveralframes\else%
  \let\howtotreatframe\dosingleframe%
  \fi%
  \dowhat%
  \else%
  \let\howtotreatframe\donoframe%
  \fi%
  \if@notesnormals\else\let\howtotreatframe\donoframe\fi%
  \howtotreatframe}
\long\def\donoframe{%
  \serialnumber=1\relax%
  \@serialnumber=1\relax%
  \setbox\tempbox\vbox\bgroup\leavevmode\afterassignment\@checknoslide\let\@next}
\def\@checknoslide{%
  \ifcat\bgroup\noexpand\@next%
  \let\@do\relax%
  \else\let\@do\@singletoken\fi%
  \@do}

\long\def\doseveralframes#1{%
  \@serialnumber=1\relax%
  \loop%
  \@anotherslidefalse%
  \def\dowhat{}%
  \def\doit{\begin{frameslide}[\@serialnumber]%
    #1%
  \end{frameslide}}%
  \serialnumber=\@serialnumber%
  {\setbox0=\hbox{\expandafter\decode\@whichframes| stop:| }}%
  \dowhat%
  \if@anotherslide
  \advance\@serialnumber by 1\relax
  \repeat}

\def\dosingleframe{\begin{frameslide}[1]\bgroup\aftergroup\@endslide\afterassignment\@checkslide\let\@next}
\def\@checkslide{%
  \ifcat\bgroup\noexpand\@next%
  \let\@do\relax%
  \else\let\@do\@singletoken\fi%
  \@do}
\def\@endslide{\end{frameslide}}
\def\@singletoken{\@next\egroup}


% Sets dowhat to doif, if \serialnumber is in the specified
% interval. Example: 5-7,-3,9,11,13- would mean pages
% 1,2,3,5,6,7,9,11,13,14,15,16,... 
%
% As a side effect, \@another is called whenever the there is a number
% in the list that is larger than the current serialnumber

\def\decode{\gdef\@decodefound{+}\@@decodefind}
\def\@@decodefind{\futurelet\@next\@decodeinsertdefault}
\def\@decodeinsertdefault{\ifcat\@next a%
  \gdef\@next{}%
  \else%
  \gdef\@next{default:}%
  \fi%
  \expandafter\@decodefind\@next}

\def\@modestop{stop}
\def\@modeall{all}
\def\@decodefind#1:#2| {%
  \def\@mode{#1}%
  \ifx\@mode\@modestop%
    \expandafter\@decode\@decodefound,!%
    \let\@next=\relax%
  \else
    \ifx\@mode\@currentmode%
      \gdef\@decodefound{#2}%
    \else%
      \ifx\@mode\@modeall%
        \gdef\@decodefound{#2}%
      \fi%
    \fi%
    \let\@next=\@@decodefind%
  \fi%
  \@next}

\def\dowhat{}
\def\@decode{%
  \@ifnextchar!%
  {\@decodeend}%
  {%
    \@ifnextchar+%
    {\@decodeall}{%
      \@ifnextchar-%
      {\@decodeuntil}%
      {\@decodenumber}}}}
\def\@decodeend!{}
\def\@decodeall+,{\ifnum1>\serialnumber\global\@anotherslidetrue\fi\gdef\dowhat{\doit}\@decode}
\def\@decodeuntil-#1,{%
  \ifnum#1>\serialnumber\global\@anotherslidetrue\fi%
  \ifnum\serialnumber>#1\else\gdef\dowhat{\doit}\fi%
  \@decode}
\def\@decodenumber#1{%
  \@ifnextchar,%
  {\@decodeone{#1}}%
  {\@ifnextchar-%
    {\@decodenumberto{#1}}%
    {\@decodegobble{#1}}}}
\def\@decodegobble#1#2{%
  \@decodenumber{#1#2}}
\def\@decodenumberto#1-{
  \@ifnextchar,%
  {\@decodeto{#1}}%
  {\@decodebetween{#1}}}
\def\@decodeto#1,{%
  \ifnum#1>\serialnumber\global\@anotherslidetrue\fi%
  \ifnum#1>\serialnumber\else\gdef\dowhat{\doit}\fi%
  \@decode}
\def\@decodebetween#1#2,{%
  \ifnum#1>\serialnumber\global\@anotherslidetrue\fi%
  \ifnum#2>\serialnumber\global\@anotherslidetrue\fi%
  \ifnum#1>\serialnumber\else\ifnum#2<\serialnumber\else\gdef\dowhat{\doit}\fi\fi%
  \@decode}
\def\@decodeone#1,{%
  \ifnum#1>\serialnumber\global\@anotherslidetrue\fi%
  \ifnum#1=\serialnumber\gdef\dowhat{\doit}\fi%
  \@decode}
                                

\long\def\gobble{\@gobble}
\long\def\gobbleoptional{\@ifnextchar[{\@gobbleoptional}{\@gobbleoptional[]}}
\long\def\@gobbleoptional[#1]#2{}

\long\def\@insp#1{\ignorespaces#1\ignorespaces}
\long\def\@gobbleis#1{\ignorespaces}

\long\def\makeinvisible#1{\pgfsys@begininvisible#1\pgfsys@endinvisible}
\long\def\fakeinvisible#1{\pgfsys@begininvisible\pgfsys@endinvisible#1\pgfsys@begininvisible\pgfsys@endinvisible}

%
% Overlay commands
%

\newoverlaycommand{\pgfonly}{\@insp}{\@gobbleis}
\newoverlaycommand{\only}{}{\gobble}
\newoverlaycommand{\uncover}{\fakeinvisible}{\makeinvisible}
\renewoverlaycommand{\textbf}{\original{\textbf}}{}
\renewoverlaycommand{\textit}{\original{\textit}}{}
\renewoverlaycommand{\textsl}{\original{\textsl}}{}
\renewoverlaycommand{\textsf}{\original{\textsf}}{}
\renewoverlaycommand{\textrm}{\original{\textrm}}{}
\renewoverlaycommand{\color}{\original{\color}}{\gobbleoptional}
\newoverlayenvironment{uncoverenv}{}{}{\pgfsys@begininvisible}{\pgfsys@endinvisible}
\newoverlayenvironment{onlyenv}{}{}{\begingroup\setbox0=\hbox\bgroup}{\egroup\endgroup}

\newoverlaycommand{\emph}{\@emph}{}
\def\@emph#1{{\slshape#1}}



%
% Alerting
%

\newoverlaycommand{\alert}{\@alert}{}
\def\@alert#1{\def\insertalert{#1}\@alerttemplate}

\newoverlaycommand{\structure}{\@structure}{}
\def\@structure#1{\def\insertstructure{#1}\@structuretemplate}

\long\def\usealerttemplate#1{%
  \def\@alerttemplate{#1}}
\long\def\usestructuretemplate#1{%
  \def\@structuretemplate{#1}}

\usealerttemplate{{\color{red}\insertalert}}
\usestructuretemplate{{\color{structure}\insertstructure}}


% Insert area

\newbox\areabox
\newdimen\finalheight
\newenvironment{overlayarea}[2]{%
  \finalheight=#2\relax%
  \advance\finalheight by-\baselineskip%
  \setbox\areabox=\hbox\bgroup%
  \begin{minipage}[t]{#1}%
  }
  {
  \end{minipage}%
  \egroup%
  \ht\areabox=0pt%
  \dp\areabox=\finalheight%
  \box\areabox%
}

\newbox\@animcurrent
\newbox\@animshowbox
\newdimen\@animht
\newdimen\@animdp
\newdimen\@animwidth
\def\overprint{\@ifnextchar[{\@overprint}{\@overprint[\textwidth]}}
\def\@overprint[#1]{%
  \@animht=0pt%
  \@animdp=0pt%
  \@animwidth=#1\relax%
  \setbox\@animcurrent=\box\@animshowbox% makes animshowbox empty
  \setbox\@animcurrent=\hbox{}%
  \def\@endaction{}%
}
\def\endoverprint{%
  \@endaction%
  \ifvoid\@animshowbox\setbox\@animshowbox=\hbox{}\fi%
  \ht\@animshowbox=\@animht%
  \dp\@animshowbox=\@animdp%
  \wd\@animshowbox=\@animwidth%
  \box\@animshowbox%
}

\def\onslide<#1>{%
  \@endaction%
  \alt<#1>{%
    \ifvoid\@animshowbox\else\ClassError{beamer}{Overprints may not overlap}{}\fi%
    \def\@endaction{%
    \end{minipage}%
    \egroup%
      \ifdim\@animht<\ht\@animcurrent\@animht=\ht\@animcurrent\fi%
      \ifdim\@animdp<\dp\@animcurrent\@animdp=\dp\@animcurrent\fi%
      \setbox\@animshowbox=\copy\@animcurrent}
  }%
  {\def\@endaction{%
    \end{minipage}%
    \egroup%
      \ifdim\@animht<\ht\@animcurrent\@animht=\ht\@animcurrent\fi%
      \ifdim\@animdp<\dp\@animcurrent\@animdp=\dp\@animcurrent\fi}%
  }%
  \setbox\@animcurrent=\vbox\bgroup\begin{minipage}[t]{\@animwidth}%
}


%
%
% Head Navigation Format
%
%


\newbox\sectionbox

\newbox\tempbox
\newdimen\tempheight

\let\@mkboth\@gobbletwo
\def\ps@navigation{
  \def\@oddhead{\setbox\tempbox=\hbox{\@backgroundtemplate}\tempheight=\ht\tempbox\setbox\tempbox=\hbox{\lower\tempheight\hbox{\box\tempbox}}\wd\tempbox=0pt\ht\tempbox=0pt\dp\tempbox=0pt%
    \vbox{\hbox{\hskip-\Geom@lmargin\box\tempbox}\hbox{\@headtemplate}\hfil}}
  \def\@oddfoot{\@foottemplate\hypertarget{Navigation\thepage}{}\hfill}
  \let\@evenhead\@oddhead
  \let\@evenfoot\@oddfoot}
\pagestyle{navigation}

\long\def\usebackgroundtemplate#1{%
  \def\@backgroundtemplate{#1}}

\def\recalculatefoot{%
    \setbox\tempbox=\hbox{\@foottemplate}%
    \postemp=\ht\tempbox%
    \advance\postemp by \dp\tempbox%
    \advance\postemp by 4pt%
    \geometry{foot=\the\postemp}}
\def\recalculatehead{%
  \setbox\tempbox=\hbox{\@headtemplate}%
  \headheight=\ht\tempbox%
  \advance\headheight by\dp\tempbox%
  \geometry{head=\the\headheight}}%

\long\def\usefoottemplate#1{%
  \def\@foottemplate{\offinterlineskip\reset@font\def\\{,}#1}%
  \recalculatefoot}
\def\insertpagenumber{\thepage}

\long\def\useheadtemplate#1{%
  \def\@headtemplate{\offinterlineskip\reset@font#1}%
  \recalculatehead} 

\def\insertvrule#1#2{%
  \hbox{\color{#2}\hskip-\Geom@lmargin\vrule width \paperwidth
    height #1\hskip-\Geom@rmargin}}

\newbox\navigationbox
\def\insertnavigation#1{%
  \vbox{%
    \hbox to #1{\hskip.3cm\sffamily\tiny\setbox\sectionbox=\hbox{}%
        \hskip0pt plus-1fill\dohead%
      \box\sectionbox\hfil\hskip.3cm}%
  }}

\def\sectionentry#1#2#3#4{% section name, section title, page
  \box\sectionbox\hfill
  \setbox\sectionbox=
  \hbox{\def\insertsectionhead{#2}%
    \ifnum\thesection=#1%
    \hyperlink{Navigation#3}{\@sectionheadhilight}\else%
    \hyperlink{Navigation#3}{\@sectionheadnohilight}\fi}%
  \ignorespaces}

\long\def\usesectionheadtemplate#1#2{\def\@sectionheadhilight{#1}\def\@sectionheadnohilight{#2}}


\newdimen\boxsize
\newdimen\vboxoffset
\newdimen\postemp
\newdimen\headheight


\def\slideentry#1#2#3#4#5{%
  %section number, subsection number, slide number, page number
  \ifnum#2>0\ifnum#3>0%
  \hbox to 0pt{%
    \postemp=-#2\vboxoffset%
    \advance\postemp by -#2\boxsize%
    \advance\postemp by -.05cm%
    \raise\postemp\hbox{%
      \postemp=#3\boxsize%
      \advance\postemp by -\boxsize%
      \advance\postemp by 1pt%
      \kern\postemp\hbox{\hyperlink{Navigation#4}{%
        \ifnum\thesection=#1\ifnum\thesubsection=#2\ifnum\thesubsectionslide=#3%
        \@minislidehilight\else\@minisliderowhilight\fi\else\@minislide\fi\else\@minislide\fi%
        }}}\hskip -10cm plus 1fil
  }\fi\fi\ignorespaces}

\long\def\useminislidetemplate#1#2#3#4#5{\def\@minislidehilight{#1}\def\@minisliderowhilight{#2}\def\@minislide{#3}
\boxsize=#4\vboxoffset=#5}

\def\insertsectionnavigation#1{%
  \hbox to #1{%
    \vbox{%
     \vskip1.5pt%
      \def\slideentry##1##2##3##4##5{}%
      \def\sectionentry##1##2##3##4{\def\insertsectionhead{##4}%
        \setbox\tempbox=\hbox to #1{%
          \hyperlink{Navigation##3}{\hfill\ifnum\thesection=##1%
          \@sectionheadhilight\else\@sectionheadnohilight\fi\hskip0.3cm}}%
        \ht\tempbox=4.5pt\dp\tempbox=2pt%        
        \box\tempbox}%
      \dohead\vskip1.5pt}\hfill}}

\newcount\currentsubsection
\def\insertsubsectionnavigation#1{%
  \hbox to #1{%
    \vbox{%
      \vskip1.5pt%
      \currentsubsection=1%
      \def\sectionentry##1##2##3##4{}%
      \def\slideentry##1##2##3##4##5{\ifnum##1=\thesection%
        \ifnum##2=\currentsubsection%
        \advance\currentsubsection by1%
        \def\insertsubsectionhead{##5}%
        \setbox\tempbox=\hbox to #1{\hyperlink{Navigation##4}{%
          \hskip0.3cm\ifnum\thesubsection=##2%
          \@subsectionheadhilight\else\@subsectionheadnohilight\fi\hfill}}%
        \ht\tempbox=4.5pt\dp\tempbox=2pt%
        \box\tempbox\fi\fi}%
      \dohead\vskip1.5pt}\hfill}}

\long\def\usesubsectionheadtemplate#1#2{\def\@subsectionheadhilight{#1}\def\@subsectionheadnohilight{#2}}


%
%
% Predefined Blocks
%
%

\long\def\useblocktemplate#1#2{%
  \def\@beginblocktemplate{#1}
  \def\@endblocktemplate{#2}}

\long\def\usealertblocktemplate#1#2{%
  \def\@beginalertblocktemplate{#1}
  \def\@endalertblocktemplate{#2}}

\long\def\useexampleblocktemplate#1#2{%
  \def\@beginexampleblocktemplate{#1}
  \def\@endexampleblocktemplate{#2}}

\newoverlayenvironment{block}[1]{%
  \def\insertblockname{#1}%
  \par%
  \@beginblocktemplate}{\par\@endblocktemplate}%
  {\pgfsys@begininvisible%
  \def\insertblockname{#1}%
  \par%
  \@beginblocktemplate}{\par\@endblocktemplate\pgfsys@endinvisible}

\newoverlayenvironment{alertblock}[1]{%
  \def\insertblockname{#1}%
  \par%
  \@beginalertblocktemplate}{\par\@endalertblocktemplate}%
  {\pgfsys@begininvisible%
  \def\insertblockname{#1}%
  \par%
  \@beginalertblocktemplate}{\par\@endalertblocktemplate\pgfsys@endinvisible}

\newoverlayenvironment{exampleblock}[1]{%
  \def\insertblockname{#1}%
  \par%
  \@beginexampleblocktemplate}{\par\@endexampleblocktemplate}%
  {\pgfsys@begininvisible%
  \def\insertblockname{#1}%
  \par%
  \@beginexampleblocktemplate}{\par\@endexampleblocktemplate\pgfsys@endinvisible}

\newenvironment{Problem}{\begin{block}{Problem}}{\end{block}}
\newenvironment{Loesung}{\begin{block}{L\"osung}}{\end{block}}
\newenvironment{Definition}{\begin{block}{Definition}}{\end{block}}
\newenvironment{Satz}{\begin{block}{Satz}}{\end{block}}
\newenvironment{Beweis}{\begin{block}{Beweis.}}{\end{block}}
\newenvironment{Folgerung}{\begin{block}{Folgerung}}{\end{block}}
\newenvironment{Lemma}{\begin{block}{Lemma}}{\end{block}}
\newenvironment{Fakt}{\begin{block}{Fakt}}{\end{block}}
\newenvironment{Beispiel}{\begin{exampleblock}{Beispiel}}{\end{exampleblock}}
\newenvironment{Beispiele}{\begin{exampleblock}{Beispiele}}{\end{exampleblock}}

\newenvironment{Theorem}{\begin{block}{Theorem}}{\end{block}}
\newenvironment{Proof}{\begin{block}{Proof.}}{\end{block}}
\newenvironment{Corollary}{\begin{block}{Corollary}}{\end{block}}
\newenvironment{Fact}{\begin{block}{Fact}}{\end{block}}
\newenvironment{Example}{\begin{exampleblock}{Example}}{\end{exampleblock}}
\newenvironment{Examples}{\begin{exampleblock}{Examples}}{\end{exampleblock}}

\newenvironment{definition}{\begin{block}{Definition}}{\end{block}}
\newenvironment{definitions}{\begin{block}{Definitions}}{\end{block}}
\newenvironment{theorem}{\begin{block}{Theorem}}{\end{block}}
\newenvironment{proof}{\begin{block}{Proof.}}{\end{block}}
\newenvironment{corollary}{\begin{block}{Corollary}}{\end{block}}
\newenvironment{fact}{\begin{block}{Fact}}{\end{block}}
\newenvironment{example}{\begin{exampleblock}{Example}}{\end{exampleblock}}
\newenvironment{examples}{\begin{exampleblock}{Examples}}{\end{exampleblock}}

\newcommand{\BeispielInline}[1]{{\color{darkgreen}Beispiel: \ignorespaces#1}}
\newcommand{\ExampleInline}[1]{{\color{darkgreen}Example: \ignorespaces#1}}


%
%
% Columns
%
%

\newenvironment{columns}{\leavevmode\hskip-\Geom@lmargin\nobreak\hbox to\paperwidth\bgroup\hbox{}\hfill\ignorespaces}{\egroup\nobreak\hskip-\Geom@rmargin}
\newenvironment{columnsonlytextwidth}{\leavevmode\hbox to\textwidth\bgroup\ignorespaces}{\unskip\egroup}

\newenvironment{column}[1]{%
  \begin{minipage}[c]{#1}%
    \raggedright}
  {\end{minipage}\hfill\ignorespaces}





%
%
% Table of Contents Format
%
%

\newif\if@onlycurrent

\newcommand\tableofcontents{%
  \@onlycurrentfalse%
  \vspace*{-.5em}{\makeatletter\@input{\jobname.toc}\vfill}%
  \color{black}
}

\newcommand\tableofcontentscurrent{%
  \@onlycurrenttrue%
  \vspace*{-.5em}{\makeatletter\@input{\jobname.toc}\vfill}%
  \color{black}
}

\def\sectionintoc#1#2#3{%
  \def\inserttocsection{\hyperlink{Navigation#3}{#2}}%
  \ifsubsectionshide
  \vskip1.5em
  \else
  \vfill
  \fi
  \if@onlycurrent%
    \ifnum\thesection=#1%
      \hbox{\vbox{\sectiontemplate}}%
    \else%
      \hbox{\vbox{\sectiontemplateshaded}}%
    \fi%
  \else%
    \hbox{\vbox{\sectiontemplate}}%
  \fi
  \par}

\long\def\usetemplatetocsection#1#2{
  \def\sectiontemplate{\def\@breakhere{\\}#1}
  \def\sectiontemplateshaded{\def\@breakhere{\\}#2}}

\long\def\subsectionintoc#1#2#3#4{%
  \def\inserttocsubsection{\hyperlink{Navigation#4}{#3}}%
  \ifsubsectionshide
    \ifnum\thesection=#1
      {\@subsectiontemplate}
    \fi
  \else
    \if@onlycurrent
      \ifnum\thesection=#1
        {\@subsectiontemplate}
      \else
        {\@subsectiontemplateshaded}
      \fi
    \else
      \ifsubsectionsshaded
        {\@subsectiontemplateshaded}
      \else
        {\@subsectiontemplate}
      \fi
    \fi
  \fi
}

\long\def\usetemplatetocsubsection#1#2{
  \def\@subsectiontemplate{\def\@breakhere{\\}#1}
  \def\@subsectiontemplateshaded{\def\@breakhere{\\}#2}}

  
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}

\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\algorithmname{Algorithm}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagenumbering{arabic}
\onecolumn
\clubpenalty=2000
\widowpenalty=900
\newdimen\originalbaselineskip
\originalbaselineskip=\baselineskip

\def\enumerate{%
  \ifnum\@enumdepth>1\relax\@toodeep\else
    \advance\@enumdepth\@ne
    \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
    \csname\@enumctr starttemplate\endcsname%
      \expandafter
      \list
        \csname label\@enumctr\endcsname
        {\usecounter\@enumctr%
          \def\makelabel##1{{\hss\llap{##1}}}}%
  \fi}
\def\endenumerate{\endlist\csname\@enumctr endtemplate\endcsname}

\def\itemize{%
  \ifnum \@itemdepth >1\relax\@toodeep\else
    \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \edef\@itemctr{item\romannumeral\the\@itemdepth}%
    \csname\@itemctr starttemplate\endcsname%
    \expandafter
    \list
      \csname\@itemitem\endcsname
      {\def\makelabel##1{{\hss\llap{##1}}}}%\csname \@itemctr labeltemplate\endcsname}}}}%
      \fi}
\def\enditemize{\endlist\csname\@itemctr endtemplate\endcsname}

\def\useenumerateitemtemplate#1{% 
  \def\labelenumi{\def\insertenumlabel{\theenumi}#1}}

\def\useenumeratetemplate#1#2{% before and after
  \def\enumistarttemplate{#1}%
  \def\enumiendtemplate{#2}}

\def\usesubenumerateitemtemplate#1{%
  \def\labelenumii{\def\insertenumlabel{\theenumi}\def\insertsubenumlabel{\theenumii}#1}}

\def\usesubenumeratetemplate#1#2{% before and after
  \def\enumiistarttemplate{#1}%
  \def\enumiiendtemplate{#2}}


\def\useitemizeitemtemplate#1{%
  \def\labelitemi{#1}}%itemilabeltemplate{#1}}

\def\useitemizetemplate#1#2{% before and after
  \def\itemistarttemplate{#1}%
  \def\itemiendtemplate{#2}}

\def\usesubitemizeitemtemplate#1{%
  \def\labelitemii{#1}}%itemiilabeltemplate{#1}}

\def\usesubitemizetemplate#1#2{% before and after
  \def\itemiistarttemplate{#1}%
  \def\itemiiendtemplate{#2}}


\parindent0pt
\renewcommand\familydefault{\sfdefault}

\AtEndDocument{%
  \clearpage
    \if@filesw
      \newwrite\tf@head
      \immediate\openout\tf@head\jobname.head\relax
      \newwrite\tf@toc
      \immediate\openout\tf@toc\jobname.toc\relax
    \fi
}

\SetSymbolFont{operators}{normal}{OT1}{cmss}{m}{n}

\DeclareSymbolFont{sansnum}{OT1}{cmss}{m}{n}
\SetSymbolFont{sansnum}{bold}{OT1}{cmss}{bx}{n}
\DeclareSymbolFont{sanslet}{OT1}{cmss}{m}{sl}
\SetSymbolFont{sanslet}{bold}{OT1}{cmss}{bx}{sl}


\DeclareMathSymbol{0}\mathalpha{sansnum}{"30}
\DeclareMathSymbol{1}\mathalpha{sansnum}{"31}
\DeclareMathSymbol{2}\mathalpha{sansnum}{"32}
\DeclareMathSymbol{3}\mathalpha{sansnum}{"33}
\DeclareMathSymbol{4}\mathalpha{sansnum}{"34}
\DeclareMathSymbol{5}\mathalpha{sansnum}{"35}
\DeclareMathSymbol{6}\mathalpha{sansnum}{"36}
\DeclareMathSymbol{7}\mathalpha{sansnum}{"37}
\DeclareMathSymbol{8}\mathalpha{sansnum}{"38}
\DeclareMathSymbol{9}\mathalpha{sansnum}{"39}

\DeclareMathSymbol{A}\mathalpha{sanslet}{"41}
\DeclareMathSymbol{B}\mathalpha{sanslet}{"42}
\DeclareMathSymbol{C}\mathalpha{sanslet}{"43}
\DeclareMathSymbol{D}\mathalpha{sanslet}{"44}
\DeclareMathSymbol{E}\mathalpha{sanslet}{"45}
\DeclareMathSymbol{F}\mathalpha{sanslet}{"46}
\DeclareMathSymbol{G}\mathalpha{sanslet}{"47}
\DeclareMathSymbol{H}\mathalpha{sanslet}{"48}
\DeclareMathSymbol{I}\mathalpha{sanslet}{"49}
\DeclareMathSymbol{J}\mathalpha{sanslet}{"4A}
\DeclareMathSymbol{K}\mathalpha{sanslet}{"4B}
\DeclareMathSymbol{L}\mathalpha{sanslet}{"4C}
\DeclareMathSymbol{M}\mathalpha{sanslet}{"4D}
\DeclareMathSymbol{N}\mathalpha{sanslet}{"4E}
\DeclareMathSymbol{O}\mathalpha{sanslet}{"4F}
\DeclareMathSymbol{P}\mathalpha{sanslet}{"50}
\DeclareMathSymbol{Q}\mathalpha{sanslet}{"51}
\DeclareMathSymbol{R}\mathalpha{sanslet}{"52}
\DeclareMathSymbol{S}\mathalpha{sanslet}{"53}
\DeclareMathSymbol{T}\mathalpha{sanslet}{"54}
\DeclareMathSymbol{U}\mathalpha{sanslet}{"55}
\DeclareMathSymbol{V}\mathalpha{sanslet}{"56}
\DeclareMathSymbol{W}\mathalpha{sanslet}{"57}
\DeclareMathSymbol{X}\mathalpha{sanslet}{"58}
\DeclareMathSymbol{Y}\mathalpha{sanslet}{"59}
\DeclareMathSymbol{Z}\mathalpha{sanslet}{"5A}

\DeclareMathSymbol{a}\mathalpha{sanslet}{"61}
\DeclareMathSymbol{b}\mathalpha{sanslet}{"62}
\DeclareMathSymbol{c}\mathalpha{sanslet}{"63}
\DeclareMathSymbol{d}\mathalpha{sanslet}{"64}
\DeclareMathSymbol{e}\mathalpha{sanslet}{"65}
\DeclareMathSymbol{f}\mathalpha{sanslet}{"66}
\DeclareMathSymbol{g}\mathalpha{sanslet}{"67}
\DeclareMathSymbol{h}\mathalpha{sanslet}{"68}
\DeclareMathSymbol{i}\mathalpha{sanslet}{"69}
\DeclareMathSymbol{j}\mathalpha{sanslet}{"6A}
\DeclareMathSymbol{k}\mathalpha{sanslet}{"6B}
\DeclareMathSymbol{l}\mathalpha{sanslet}{"6C}
\DeclareMathSymbol{m}\mathalpha{sanslet}{"6D}
\DeclareMathSymbol{n}\mathalpha{sanslet}{"6E}
\DeclareMathSymbol{o}\mathalpha{sanslet}{"6F}
\DeclareMathSymbol{p}\mathalpha{sanslet}{"70}
\DeclareMathSymbol{q}\mathalpha{sanslet}{"71}
\DeclareMathSymbol{r}\mathalpha{sanslet}{"72}
\DeclareMathSymbol{s}\mathalpha{sanslet}{"73}
\DeclareMathSymbol{t}\mathalpha{sanslet}{"74}
\DeclareMathSymbol{u}\mathalpha{sanslet}{"75}
\DeclareMathSymbol{v}\mathalpha{sanslet}{"76}
\DeclareMathSymbol{w}\mathalpha{sanslet}{"77}
\DeclareMathSymbol{x}\mathalpha{sanslet}{"78}
\DeclareMathSymbol{y}\mathalpha{sanslet}{"79}
\DeclareMathSymbol{z}\mathalpha{sanslet}{"7A}

\raggedright

\newbox\logobox

\newbox\linebox
\def\tinyline#1{%
  \setbox\linebox=\hbox to\textwidth{\hskip-\Geom@lmargin\hskip0.3cm\tiny{#1}\hskip-\Geom@rmargin\hskip0.3cm}%
  \ht\linebox=5.5pt%
  \dp\linebox=0pt%
  \box\linebox%
  \vskip3pt}
\def\tinycolouredline#1#2{%
  \hbox{%
    \setbox\linebox=\hbox to\textwidth{\hskip-\Geom@lmargin\hskip0.3cm\tiny{#2}\hskip-\Geom@rmargin\hskip0.3cm}%
    \ht\linebox=7pt%
    \dp\linebox=0pt%
    \setbox\linebox=\vbox{\box\linebox\vskip3pt}%
    {\color{#1}\hskip-\Geom@lmargin\vrule width\paperwidth
      height\ht\linebox\hskip-\paperwidth\hskip\Geom@lmargin}%
    \box\linebox}%
  }
\def\colouredline#1#2{%
  \hbox{%
    \setbox\linebox=\hbox to\textwidth{\hskip-\Geom@lmargin\hskip0.3cm{#2}\hskip-\Geom@rmargin\hskip0.3cm}%
    \setbox\linebox=\vbox{\vskip2pt\box\linebox\vskip2pt}%
    {\color{#1}\hskip-\Geom@lmargin\vrule width\paperwidth
      height\ht\linebox\hskip-\paperwidth\hskip\Geom@lmargin}%
    \box\linebox}%
  }
\def\line#1{%
  \hbox{\hskip-\Geom@lmargin#1\hskip-\Geom@rmargin}}




%
%
% Default Theme
%
%

  
                                % Title page  
\usetitlepagetemplate{
  \vbox{}
  \vfill
  \begin{centering}
    \Large\structure{\inserttitletitle}
    \vskip1em\par
    \normalsize\insertauthortitle\vskip1em\par
    {\scriptsize\insertinstitute\par}\par\vskip1em
    \insertdate\par\vskip1.5em
    \inserttitlegraphic
  \end{centering}
  \vfill
  }

                                % Frametitles
\useframetitletemplate{%
  \begin{centering}
    \structure{\textbf{\insertframetitle}}
    \par
  \end{centering}
}

                                % Sections in headline
\usesectionheadtemplate
{\color{structure}\tiny\insertsectionhead}
{\color{structureshaded}\tiny\insertsectionhead}

\usesubsectionheadtemplate
{\color{structure}\tiny\insertsubsectionhead}
{\color{structureshaded}\tiny\insertsubsectionhead}

                                % Mini slides in headline
\def\sphereradius{0.05cm}
\useminislidetemplate
{%
  \begin{pgfpicture}{0pt}{0pt}{0.1cm}{0.1cm}
    \color{structure}
    \pgfcircle[fillstroke]{\pgfpoint{\sphereradius}{\sphereradius}}{\sphereradius}%
  \end{pgfpicture}%
  }  
{%
  \begin{pgfpicture}{0pt}{0pt}{0.1cm}{0.1cm}
    \color{structure}
    \pgfcircle[stroke]{\pgfpoint{\sphereradius}{\sphereradius}}{\sphereradius}%
  \end{pgfpicture}%
  }
{%
  \begin{pgfpicture}{0pt}{0pt}{0.1cm}{0.1cm}
    \color{structureshaded}
    \pgfcircle[stroke]{\pgfpoint{\sphereradius}{\sphereradius}}{\sphereradius}%
  \end{pgfpicture}%
  }
{.14cm}{.03cm}

                                % Entries in table of contents
\usetemplatetocsection
{\color{structure}\inserttocsection}
{\color{structureshaded}\inserttocsection}

                                % Entries in table of contents
\usetemplatetocsubsection
{\leavevmode\leftskip=1.5em\color{black}\inserttocsubsection\par}
{\leavevmode\leftskip=1.5em\color{shaded}\inserttocsubsection\par}

                                % Head
\useheadtemplate{%
  \vbox{%
  \vskip3pt%
  \hbox{\hskip-\Geom@lmargin\insertnavigation{\paperwidth}\hskip-\Geom@rmargin}%
  \vskip1.5pt%
  \insertvrule{0.4pt}{structureshaded}}%
}

                                % Footline
\usefoottemplate{}

                                % Background
\usebackgroundtemplate{}

                                % Blocks
\useblocktemplate{\medskip{\color{blockstructure}\textbf{\insertblockname}}\par}{\medskip}
\usealertblocktemplate{\medskip{\alert{\textbf{\insertblockname}}}\par}{\medskip}
\useexampleblocktemplate{\medskip\begingroup\color{darkgreen}{\textbf{\insertblockname}}\par}{\endgroup\medskip}

                                % Enumerations
\useenumerateitemtemplate{\color{structure}\insertenumlabel.}
\usesubenumerateitemtemplate{\color{structure}\insertenumlabel.\insertsubenumlabel}
\useenumeratetemplate{}{}
\usesubenumeratetemplate{\begin{small}}{\end{small}}

                                % Itemize
\useitemizeitemtemplate{\scriptsize\raise1.25pt\hbox{\color{structure}$\blacktriangleright$}}
\usesubitemizeitemtemplate{\tiny\raise1.5pt\hbox{\color{structure}$\blacktriangleright$}}
\useitemizetemplate{}{}
\usesubitemizetemplate{\begin{small}}{\end{small}}


%
% Notes
%

\long\def\note#1{%
  \if@notes
  {
  \def\@oddhead{}
  \def\@oddfoot{}
  \let\@evenhead\@oddhead
  \let\@evenfoot\@oddfoot
  \def\@backgroundtemplate{}
  \vbox{%
    \vskip-\headheight%
    \insertvrule{8em}{lightgray}
    \vskip-8.5em
    \hbox{\vbox{
    \begin{pgfpicture}{0cm}{0cm}{0cm}{0cm}
      \begin{pgfrotateby}{\pgfdegree{90}}
        \pgfputat{\pgfpoint{-2cm}{0.25cm}}{\pgfbox[base,left]{\footnotesize\the\year-\ifnum\month<10\relax0\fi\the\month-\ifnum\day<10\relax0\fi\the\day}}
      \end{pgfrotateby}
    \end{pgfpicture}}}
    \hbox{\vbox{\begin{minipage}[t]{8cm}\inserttitle\end{minipage}}}%
    \setbox\tempbox=\hbox{\insertsection}%
    \hbox{\ifdim\wd\tempbox>1pt{\hskip4pt\raise3pt\hbox{\vrule width0.4pt height9pt\vrule width 9pt height0.4pt}}\hskip1pt\hbox{\vbox{\begin{minipage}[t]{8cm}\insertsection\end{minipage}}}\fi}%
    \setbox\tempbox=\hbox{\insertsubsection}%
    \hbox{\ifdim\wd\tempbox>1pt{\hskip17.4pt\raise3pt\hbox{\vrule width0.4pt height9pt\vrule width 9pt height0.4pt}}\hskip1pt\hbox{\vbox{\begin{minipage}[t]{8cm}\insertsubsection\end{minipage}}}\fi}%
    \setbox\tempbox=\hbox{\insertframetitle}%
    \hbox{\ifdim\wd\tempbox>1pt{\hskip30.8pt\raise3pt\hbox{\vrule width0.4pt height9pt\vrule width 9pt height0.4pt}}\hskip1pt\hbox{\vbox{\begin{minipage}[t]{8cm}\insertframetitle\end{minipage}}}\fi}%
    }
  \vskip2.5em
  #1%
  \clearpage
  }\fi}

\long\def\noteitems#1{\note{\begin{itemize}#1\end{itemize}}}

