
#define TCL_USE_STUBS
#include <tcl.h>

extern Tcl_ObjCmdProc Trace_ObjCmd;
extern int Trace_Init(Tcl_Interp* interp);

static void 
traceCmd _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
	      int level, int flags, int code,
	      char* command, int length, Tcl_CmdProc *proc,
	      ClientData cmdClientData, int objc, struct Tcl_Obj *CONST objv[]));
static void 
traceCleanup _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp));

typedef struct traceInfo {
    Tcl_DString traceDetails;
    Tcl_Trace traceInfo;
} traceInfo;

int Trace_Init(Tcl_Interp* interp) {
	traceInfo* traceInfoPtr;
    Tcl_InitStubs(interp,TCL_VERSION,0);
    
    traceInfoPtr = (traceInfo*) ckalloc(sizeof(traceInfo));
    traceInfoPtr->traceInfo = NULL;
    Tcl_DStringInit(&traceInfoPtr->traceDetails);
    
    Tcl_CallWhenDeleted(interp, traceCleanup, (ClientData) traceInfoPtr);
    Tcl_CreateObjCommand(interp, "trace", Trace_ObjCmd, 
			 (ClientData)traceInfoPtr, (Tcl_CmdDeleteProc*) NULL);
    return TCL_OK;
}

void traceCleanup(ClientData clientData, Tcl_Interp *interp) {
    traceInfo* traceInfoPtr = (traceInfo*)clientData;
    Tcl_DStringFree(&traceInfoPtr->traceDetails);
    if(traceInfoPtr->traceInfo != NULL) {
	Tcl_DeleteTrace(interp,traceInfoPtr->traceInfo);
    }
}

void traceCmd(ClientData clientData, Tcl_Interp *interp, 
	      int level, int flags, int code,
	      char* command, int length, Tcl_CmdProc *proc,
	      ClientData cmdClientData, int objc, struct Tcl_Obj *CONST objv[]) {
    int i;
    traceInfo* traceInfoPtr = (traceInfo*)clientData;
    for (i = 0; i < level; i++) {
	Tcl_DStringAppend(&traceInfoPtr->traceDetails, " ", 1);
    }
    switch (flags) {
      case TCL_CMD_TRACE_BEFORE:
	for (i = 0; i < objc; i++) {
	    char* str;
	    int len;
	    str = Tcl_GetStringFromObj(objv[i],&len);
	    if (i) {
	        Tcl_DStringAppend(&traceInfoPtr->traceDetails, "'", 1);
		Tcl_DStringAppend(&traceInfoPtr->traceDetails, str, len);
		Tcl_DStringAppend(&traceInfoPtr->traceDetails, "' ", 1);
	    } else {
		Tcl_DStringAppend(&traceInfoPtr->traceDetails, str, len);
		Tcl_DStringAppend(&traceInfoPtr->traceDetails, " ", 1);
	    }
	}
	break;
      case TCL_CMD_TRACE_AFTER:
	break;
      case TCL_CMD_TRACE_RESULT:
	Tcl_DStringAppend(&traceInfoPtr->traceDetails, command, length);
	Tcl_DStringAppend(&traceInfoPtr->traceDetails, " ", 11);
	Tcl_DStringAppend(&traceInfoPtr->traceDetails, code == TCL_ERROR ? "ERROR: " : "OK: ", -1);
	Tcl_DStringAppend(&traceInfoPtr->traceDetails, Tcl_GetStringResult(interp), -1);
	break;
    }
    Tcl_DStringAppend(&traceInfoPtr->traceDetails, "\n", 1);
}
	

int Trace_ObjCmd(clientData, interp, objc, objv)
    ClientData clientData;		/* Trace info */
    Tcl_Interp *interp;			/* Current interpreter. */
    int objc;				/* Number of arguments. */
    Tcl_Obj *CONST objv[];		/* Argument objects. */
{
    int index, length;
    char *string;
    Tcl_DString ds;
    Tcl_Obj *resultPtr;
    traceInfo *traceInfoPtr = (traceInfo*)clientData;
    
    static char *optionStrings[] = {
	"dump", "on", "off", NULL
    };
    enum options {
	TRACE_DUMP, TRACE_ON, TRACE_OFF
    };
    if (objc < 2) {
	Tcl_WrongNumArgs(interp, 1, objv, "option ?arg ...?");
	return TCL_ERROR;
    }
    if (Tcl_GetIndexFromObj(interp, objv[1], optionStrings, "option", 0,
	    &index) != TCL_OK) {
	return TCL_ERROR;
    }

    switch ((enum options) index) {
      case TRACE_DUMP:
	Tcl_DStringResult(interp,&traceInfoPtr->traceDetails);
	break;
      case TRACE_ON:
	if(traceInfoPtr->traceInfo != NULL) {
	    Tcl_DeleteTrace(interp,traceInfoPtr->traceInfo);
	    Tcl_DStringFree(&traceInfoPtr->traceDetails);
	}
	if(objc < 3) {
	    Tcl_WrongNumArgs(interp, 2, objv, "procname");
	    traceInfoPtr->traceInfo = NULL;
	    return TCL_ERROR;
	}
	traceInfoPtr->traceInfo = Tcl_CreateTraceObj(interp,objv[2],0,0,0,traceCmd,NULL);
      case TRACE_OFF:
	if(traceInfoPtr->traceInfo != NULL) {
	    Tcl_DeleteTrace(interp,traceInfoPtr->traceInfo);
	}
	traceInfoPtr->traceInfo = NULL;
    }
    return TCL_OK;
}

