/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.problems.ProblemSeverity;
import org.gradle.internal.cc.impl.problems.Summary;
import org.gradle.internal.cc.impl.problems.UniquePropertyProblem;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradle/internal/cc/impl/problems/ConfigurationCacheProblemsSummary;", "", "maxCollectedProblems", "", "(I)V", "causes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "failureCount", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "overflowed", "", "problemCount", "suppressedCount", "uniqueProblems", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/gradle/internal/cc/impl/problems/UniquePropertyProblem;", "get", "Lorg/gradle/internal/cc/impl/problems/Summary;", "onProblem", "problem", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "severity", "Lorg/gradle/internal/cc/impl/problems/ProblemSeverity;", "configuration-cache"})
public final class ConfigurationCacheProblemsSummary {
    private final int maxCollectedProblems;
    private boolean overflowed;
    private int problemCount;
    private int failureCount;
    private int suppressedCount;
    @NotNull
    private ObjectOpenHashSet<UniquePropertyProblem> uniqueProblems;
    @NotNull
    private ArrayList<Throwable> causes;
    @NotNull
    private final ReentrantLock lock;

    public ConfigurationCacheProblemsSummary(int maxCollectedProblems) {
        this.maxCollectedProblems = maxCollectedProblems;
        this.uniqueProblems = new ObjectOpenHashSet();
        this.causes = new ArrayList(5);
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ ConfigurationCacheProblemsSummary(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Summary get() {
        Summary summary;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)((Collection)this.uniqueProblems));
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"copyOf(uniqueProblems)");
            Set set = (Set)immutableSet;
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.causes);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(causes)");
            summary = new Summary(this.problemCount, this.failureCount, this.suppressedCount, set, (List)immutableList, this.overflowed, this.maxCollectedProblems);
        }
        finally {
            lock.unlock();
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onProblem(@NotNull PropertyProblem problem2, @NotNull ProblemSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)problem2, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ++this.problemCount;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    ++this.failureCount;
                    break;
                }
                case 2: {
                    ++this.suppressedCount;
                }
            }
            if (this.overflowed) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.problemCount > this.maxCollectedProblems) {
                this.overflowed = true;
                boolean bl3 = false;
                return bl3;
            }
            UniquePropertyProblem uniqueProblem = UniquePropertyProblem.Companion.of(problem2);
            if (this.uniqueProblems.add((Object)uniqueProblem) && this.causes.size() < 5) {
                Throwable throwable = problem2.getException();
                if (throwable != null) {
                    Throwable it2 = throwable;
                    boolean bl4 = false;
                    this.causes.add(it2);
                }
            }
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    public ConfigurationCacheProblemsSummary() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProblemSeverity.values().length];
            try {
                nArray[ProblemSeverity.Failure.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Suppressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Info.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

