/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.math;

import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.math.BigDecimal$;
import coursierapi.shaded.scala.math.BigInt;
import coursierapi.shaded.scala.math.Ordered;
import coursierapi.shaded.scala.math.ScalaNumber;
import coursierapi.shaded.scala.math.ScalaNumericAnyConversions;
import coursierapi.shaded.scala.math.ScalaNumericConversions;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import coursierapi.shaded.scala.util.hashing.MurmurHash3$;
import java.math.MathContext;

public final class BigDecimal
extends ScalaNumber
implements Ordered<BigDecimal>,
ScalaNumericConversions {
    private final java.math.BigDecimal bigDecimal;
    private final MathContext mc;
    private int computedHashCode;

    @Override
    public boolean $less(Object that) {
        return Ordered.$less$(this, that);
    }

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    public java.math.BigDecimal bigDecimal() {
        return this.bigDecimal;
    }

    private final int computedHashCode() {
        return this.computedHashCode;
    }

    private final void computedHashCode_$eq(int x$1) {
        this.computedHashCode = x$1;
    }

    private final void computeHashCode() {
        int n;
        if (this.isWhole() && this.precision() - this.scale() < 4934) {
            n = this.toBigInt().hashCode();
        } else if (this.isDecimalDouble()) {
            n = Statics.doubleHash(this.doubleValue());
        } else {
            java.math.BigDecimal temp2 = this.bigDecimal().stripTrailingZeros();
            n = MurmurHash3$.MODULE$.mixLast(temp2.scaleByPowerOfTen(temp2.scale()).toBigInteger().hashCode(), temp2.scale());
        }
        this.computedHashCode_$eq(n);
    }

    public int hashCode() {
        if (this.computedHashCode() == 1565550863) {
            this.computeHashCode();
        }
        return this.computedHashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)that;
            return this.equals(bigDecimal);
        }
        if (that instanceof BigInt) {
            BigInt bigInt = (BigInt)that;
            if ((double)bigInt.bitLength() > (double)(this.precision() - this.scale() - 2) * 3.3219280948873626) {
                BigInt bigInt2;
                Option<BigInt> option = this.toBigIntExact();
                if (option == null) {
                    throw null;
                }
                Option<BigInt> exists_this = option;
                boolean bl = !exists_this.isEmpty() && bigInt.equals(bigInt2 = exists_this.get());
                Object var10_4 = null;
                if (bl) {
                    return true;
                }
            }
            return false;
        }
        if (that instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(that);
            if (!Double.isInfinite(d)) {
                double d2 = this.doubleValue();
                if (!Double.isInfinite(d2) && d2 == d && this.equals(BigDecimal$.MODULE$.decimal(d2))) {
                    return true;
                }
            }
            return false;
        }
        if (that instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(that);
            if (!Float.isInfinite(f)) {
                float f2 = this.floatValue();
                if (!Float.isInfinite(f2) && f2 == f && this.equals(BigDecimal$.MODULE$.decimal(f2))) {
                    return true;
                }
            }
            return false;
        }
        return this.isValidLong() && ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, that);
    }

    @Override
    public boolean isValidByte() {
        try {
            this.toByteExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    @Override
    public boolean isValidShort() {
        try {
            this.toShortExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    @Override
    public boolean isValidChar() {
        return this.isValidInt() && this.toIntExact() >= 0 && this.toIntExact() <= 65535;
    }

    @Override
    public boolean isValidInt() {
        try {
            this.toIntExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public boolean isValidLong() {
        try {
            this.toLongExact();
            return true;
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public boolean isDecimalDouble() {
        double d = this.doubleValue();
        return !Double.isInfinite(d) && this.equals(BigDecimal$.MODULE$.decimal(d));
    }

    @Override
    public boolean isWhole() {
        return this.scale() <= 0 || this.bigDecimal().stripTrailingZeros().scale() <= 0;
    }

    @Override
    public java.math.BigDecimal underlying() {
        return this.bigDecimal();
    }

    public boolean equals(BigDecimal that) {
        return this.compare(that) == 0;
    }

    @Override
    public int compare(BigDecimal that) {
        return this.bigDecimal().compareTo(that.bigDecimal());
    }

    public int precision() {
        return this.bigDecimal().precision();
    }

    public int scale() {
        return this.bigDecimal().scale();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public int intValue() {
        return this.bigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal().longValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal().doubleValue();
    }

    public byte toByteExact() {
        return this.bigDecimal().byteValueExact();
    }

    public short toShortExact() {
        return this.bigDecimal().shortValueExact();
    }

    public int toIntExact() {
        return this.bigDecimal().intValueExact();
    }

    public long toLongExact() {
        return this.bigDecimal().longValueExact();
    }

    public BigInt toBigInt() {
        return new BigInt(this.bigDecimal().toBigInteger());
    }

    public Option<BigInt> toBigIntExact() {
        if (this.isWhole()) {
            try {
                return new Some<BigInt>(new BigInt(this.bigDecimal().toBigIntegerExact()));
            }
            catch (ArithmeticException arithmeticException) {
                return None$.MODULE$;
            }
        }
        return None$.MODULE$;
    }

    public String toString() {
        return this.bigDecimal().toString();
    }

    public BigDecimal(java.math.BigDecimal bigDecimal, MathContext mc) {
        this.bigDecimal = bigDecimal;
        this.mc = mc;
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null value for BigDecimal");
        }
        if (mc == null) {
            throw new IllegalArgumentException("null MathContext for BigDecimal");
        }
        this.computedHashCode = 1565550863;
    }
}

