/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util;

import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.util.CompilerType;
import org.jetbrains.kotlin.util.GarbageCollectionStats;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.util.PhaseSideType;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.PlatformType;
import org.jetbrains.kotlin.util.PotentiallyIncorrectPhaseTimeMeasurement;
import org.jetbrains.kotlin.util.SideStats;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.UnitStats;
import org.jetbrains.kotlin.util.UnitStatsJsonDumper;
import org.jetbrains.kotlin.util.UnitStatsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010?\u001a\u00020\u0005J\u0006\u0010@\u001a\u00020AJ\u0010\u0010H\u001a\u00020A2\b\u0010I\u001a\u0004\u0018\u00010CJ\f\u0010J\u001a\u00020K*\u00020\u0003H\u0002J\u0006\u0010L\u001a\u00020AJ\u0018\u0010M\u001a\u00020A2\u0006\u00108\u001a\u0002072\u0006\u0010;\u001a\u000207H\u0016J\u000e\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020\u0013J\u000e\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u0013J\b\u0010R\u001a\u00020AH\u0016J\b\u0010S\u001a\u00020AH\u0007J\u0010\u0010T\u001a\u00020A2\u0006\u0010Q\u001a\u00020\u0013H\u0002J+\u0010U\u001a\u0002HV\"\u0004\b\u0000\u0010V2\u0006\u0010W\u001a\u00020 2\f\u0010X\u001a\b\u0012\u0004\u0012\u0002HV0YH\u0000\u00a2\u0006\u0004\bZ\u0010[J\u000e\u0010\\\u001a\u00020A2\u0006\u0010]\u001a\u00020^J\u000e\u0010_\u001a\u00020\u00052\u0006\u0010`\u001a\u00020(J\b\u0010a\u001a\u00020AH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020#0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001e\u00101\u001a\u00020(2\u0006\u0010'\u001a\u00020(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010*R\u001c\u00103\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u000b\"\u0004\b5\u00106R\u001e\u00108\u001a\u0002072\u0006\u0010'\u001a\u000207@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001e\u0010;\u001a\u0002072\u0006\u0010'\u001a\u000207@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010:R\u001e\u0010=\u001a\u00020(2\u0006\u0010'\u001a\u00020(@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010*R\u0011\u0010>\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010*R\u001b\u0010B\u001a\u00020C8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bD\u0010E\u00a8\u0006b"}, d2={"Lorg/jetbrains/kotlin/util/PerformanceManager;", "", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "presentableName", "", "<init>", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;Ljava/lang/String;)V", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPresentableName", "()Ljava/lang/String;", "thread", "Ljava/lang/Thread;", "threadMXBean", "Ljava/lang/management/ThreadMXBean;", "currentTime", "Lorg/jetbrains/kotlin/util/Time;", "currentPhaseType", "Lorg/jetbrains/kotlin/util/PhaseType;", "phaseStartTime", "compilationMXBean", "Ljava/lang/management/CompilationMXBean;", "jitStartTime", "", "Ljava/lang/Long;", "garbageCollectorMXBeans", "", "Ljava/lang/management/GarbageCollectorMXBean;", "phaseMeasurements", "Ljava/util/SortedMap;", "phaseSideMeasurements", "Lorg/jetbrains/kotlin/util/PhaseSideType;", "Lorg/jetbrains/kotlin/util/SideStats;", "gcMeasurements", "Lorg/jetbrains/kotlin/util/GarbageCollectionStats;", "jitTimeMillis", "extendedStats", "", "value", "", "isExtendedStatsEnabled", "()Z", "compilerType", "Lorg/jetbrains/kotlin/util/CompilerType;", "getCompilerType", "()Lorg/jetbrains/kotlin/util/CompilerType;", "setCompilerType", "(Lorg/jetbrains/kotlin/util/CompilerType;)V", "hasErrors", "getHasErrors", "targetDescription", "getTargetDescription", "setTargetDescription", "(Ljava/lang/String;)V", "", "files", "getFiles", "()I", "lines", "getLines", "isFinalized", "isPhaseMeasuring", "getTargetInfo", "initializeCurrentThread", "", "unitStats", "Lorg/jetbrains/kotlin/util/UnitStats;", "getUnitStats", "()Lorg/jetbrains/kotlin/util/UnitStats;", "unitStats$delegate", "Lkotlin/Lazy;", "addOtherUnitStats", "otherUnitStats", "getPlatformEnumValue", "Lorg/jetbrains/kotlin/util/PlatformType;", "enableExtendedStats", "addSourcesStats", "notifyPhaseStarted", "newPhaseType", "notifyPhaseFinished", "phaseType", "notifyCompilationFinished", "notifyCurrentPhaseFinishedIfNeeded", "finishPhase", "measureSideTime", "T", "phaseSideType", "block", "Lkotlin/Function0;", "measureSideTime$compiler_common", "(Lorg/jetbrains/kotlin/util/PhaseSideType;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dumpPerformanceReport", "destination", "Ljava/io/File;", "createPerformanceReport", "isJson", "ensureNotFinalizedAndSameThread", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nPerformanceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1#2:340\n1267#3,4:341\n*S KotlinDebug\n*F\n+ 1 PerformanceManager.kt\norg/jetbrains/kotlin/util/PerformanceManager\n*L\n180#1:341,4\n*E\n"})
public abstract class PerformanceManager {
    @NotNull
    private final TargetPlatform targetPlatform;
    @NotNull
    private final String presentableName;
    private Thread thread;
    private ThreadMXBean threadMXBean;
    @NotNull
    private PhaseType currentPhaseType;
    @Nullable
    private Time phaseStartTime;
    @Nullable
    private CompilationMXBean compilationMXBean;
    @Nullable
    private Long jitStartTime;
    @NotNull
    private List<? extends GarbageCollectorMXBean> garbageCollectorMXBeans;
    @NotNull
    private final SortedMap<PhaseType, Time> phaseMeasurements;
    @NotNull
    private final SortedMap<PhaseSideType, SideStats> phaseSideMeasurements;
    @NotNull
    private SortedMap<String, GarbageCollectionStats> gcMeasurements;
    @Nullable
    private Long jitTimeMillis;
    @NotNull
    private final List<String> extendedStats;
    private boolean isExtendedStatsEnabled;
    @NotNull
    private CompilerType compilerType;
    private boolean hasErrors;
    @Nullable
    private String targetDescription;
    private int files;
    private int lines;
    private boolean isFinalized;
    @NotNull
    private final Lazy unitStats$delegate;

    public PerformanceManager(@NotNull TargetPlatform targetPlatform, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)presentableName2, (String)"presentableName");
        this.targetPlatform = targetPlatform;
        this.presentableName = presentableName2;
        this.initializeCurrentThread();
        this.currentPhaseType = PhaseType.Initialization;
        this.phaseStartTime = this.currentTime();
        this.garbageCollectorMXBeans = CollectionsKt.emptyList();
        this.phaseMeasurements = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.phaseSideMeasurements = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.gcMeasurements = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        this.extendedStats = new ArrayList();
        this.compilerType = CompilerType.K2;
        this.unitStats$delegate = LazyKt.lazy(() -> PerformanceManager.unitStats_delegate$lambda$1(this));
    }

    @NotNull
    public final TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public final String getPresentableName() {
        return this.presentableName;
    }

    private final Time currentTime() {
        long l2 = System.nanoTime();
        ThreadMXBean threadMXBean = this.threadMXBean;
        if (threadMXBean == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadMXBean");
            threadMXBean = null;
        }
        long l3 = threadMXBean.getCurrentThreadUserTime();
        ThreadMXBean threadMXBean2 = this.threadMXBean;
        if (threadMXBean2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadMXBean");
            threadMXBean2 = null;
        }
        return new Time(l2, l3, threadMXBean2.getCurrentThreadCpuTime());
    }

    public final boolean isExtendedStatsEnabled() {
        return this.isExtendedStatsEnabled;
    }

    @NotNull
    public final CompilerType getCompilerType() {
        return this.compilerType;
    }

    public final void setCompilerType(@NotNull CompilerType compilerType) {
        Intrinsics.checkNotNullParameter((Object)((Object)compilerType), (String)"<set-?>");
        this.compilerType = compilerType;
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    @Nullable
    public final String getTargetDescription() {
        return this.targetDescription;
    }

    public final void setTargetDescription(@Nullable String string) {
        this.targetDescription = string;
    }

    public final int getFiles() {
        return this.files;
    }

    public final int getLines() {
        return this.lines;
    }

    public final boolean isFinalized() {
        return this.isFinalized;
    }

    public final boolean isPhaseMeasuring() {
        return this.phaseStartTime != null;
    }

    @NotNull
    public final String getTargetInfo() {
        return this.targetDescription + ", " + this.files + " files (" + this.lines + " lines)";
    }

    /*
     * WARNING - void declaration
     */
    public final void initializeCurrentThread() {
        void it;
        ThreadMXBean threadMXBean;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        this.thread = thread;
        ThreadMXBean threadMXBean2 = threadMXBean = ManagementFactory.getThreadMXBean();
        PerformanceManager performanceManager = this;
        boolean bl = false;
        it.setThreadCpuTimeEnabled(true);
        ThreadMXBean threadMXBean3 = threadMXBean;
        Intrinsics.checkNotNullExpressionValue((Object)threadMXBean3, (String)"also(...)");
        performanceManager.threadMXBean = threadMXBean3;
    }

    @NotNull
    public final UnitStats getUnitStats() {
        Lazy lazy = this.unitStats$delegate;
        return (UnitStats)lazy.getValue();
    }

    public final void addOtherUnitStats(@Nullable UnitStats otherUnitStats) {
        block4: {
            boolean bl;
            this.ensureNotFinalizedAndSameThread();
            if (otherUnitStats == null) {
                return;
            }
            boolean bl2 = bl = this.getPlatformEnumValue(this.targetPlatform) == otherUnitStats.getPlatform();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.compilerType = this.compilerType.plus(otherUnitStats.getCompilerType());
            this.hasErrors = this.hasErrors || otherUnitStats.getHasErrors();
            this.addSourcesStats(otherUnitStats.getFilesCount(), otherUnitStats.getLinesCount());
            UnitStatsKt.forEachPhaseMeasurement(otherUnitStats, (Function2<? super PhaseType, ? super Time, Unit>)((Function2)(arg_0, arg_1) -> PerformanceManager.addOtherUnitStats$lambda$2(this, arg_0, arg_1)));
            UnitStatsKt.forEachPhaseSideMeasurement(otherUnitStats, (Function2<? super PhaseSideType, ? super SideStats, Unit>)((Function2)(arg_0, arg_1) -> PerformanceManager.addOtherUnitStats$lambda$3(this, arg_0, arg_1)));
            for (GarbageCollectionStats otherGcStats : otherUnitStats.getGcStats()) {
                GarbageCollectionStats existingGcMeasurement = (GarbageCollectionStats)this.gcMeasurements.get(otherGcStats.getKind());
                Map map = this.gcMeasurements;
                String string = otherGcStats.getKind();
                GarbageCollectionStats garbageCollectionStats = existingGcMeasurement;
                GarbageCollectionStats garbageCollectionStats2 = existingGcMeasurement;
                GarbageCollectionStats garbageCollectionStats3 = new GarbageCollectionStats(otherGcStats.getKind(), (garbageCollectionStats != null ? garbageCollectionStats.getMillis() : 0L) + otherGcStats.getMillis(), (garbageCollectionStats2 != null ? garbageCollectionStats2.getCount() : 0L) + otherGcStats.getCount());
                map.put(string, garbageCollectionStats3);
            }
            if (this.jitTimeMillis != null || otherUnitStats.getJitTimeMillis() != null) {
                Long l2 = this.jitTimeMillis;
                Long l3 = otherUnitStats.getJitTimeMillis();
                this.jitTimeMillis = (l2 != null ? l2 : 0L) + (l3 != null ? l3 : 0L);
            }
            List<String> list = otherUnitStats.getExtendedStats();
            if (list == null) break block4;
            List<String> it = list;
            boolean bl3 = false;
            this.extendedStats.addAll((Collection<String>)it);
        }
    }

    private final PlatformType getPlatformEnumValue(TargetPlatform $this$getPlatformEnumValue) {
        PlatformType platformType;
        String firstPlatformName = ((SimplePlatform)CollectionsKt.first((Iterable)$this$getPlatformEnumValue.getComponentPlatforms())).getPlatformName();
        if (StringsKt.contains$default((CharSequence)firstPlatformName, (CharSequence)"JVM", (boolean)false, (int)2, null)) {
            platformType = PlatformType.JVM;
        } else if (StringsKt.contains$default((CharSequence)firstPlatformName, (CharSequence)"Native", (boolean)false, (int)2, null)) {
            platformType = PlatformType.Native;
        } else if (JsPlatformKt.isJs(this.targetPlatform)) {
            platformType = PlatformType.JS;
        } else if (TargetPlatformKt.isCommon(this.targetPlatform)) {
            platformType = PlatformType.Common;
        } else {
            throw new IllegalStateException(("Unexpected platform " + this.targetPlatform).toString());
        }
        PlatformType platform = platformType;
        return platform;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableExtendedStats() {
        void $this$associateTo$iv;
        this.isExtendedStatsEnabled = true;
        if (!this.compilerType.isK2()) {
            PerformanceCounter.Companion.setTimeCounterEnabled(true);
        }
        CompilationMXBean compilationMXBean = this.compilationMXBean = ManagementFactory.getCompilationMXBean();
        this.jitStartTime = compilationMXBean != null ? Long.valueOf(compilationMXBean.getTotalCompilationTime()) : null;
        List<GarbageCollectorMXBean> list = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGarbageCollectorMXBeans(...)");
        this.garbageCollectorMXBeans = list;
        Iterable iterable = this.garbageCollectorMXBeans;
        Map destination$iv = this.gcMeasurements;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = destination$iv;
            GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            Pair pair = TuplesKt.to((Object)string, (Object)new GarbageCollectionStats(string2, it.getCollectionTime(), it.getCollectionCount()));
            map.put(pair.getFirst(), pair.getSecond());
        }
    }

    public void addSourcesStats(int files2, int lines) {
        this.ensureNotFinalizedAndSameThread();
        this.files += files2;
        this.lines += lines;
    }

    public final void notifyPhaseStarted(@NotNull PhaseType newPhaseType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)newPhaseType), (String)"newPhaseType");
        boolean bl2 = bl = this.phaseStartTime == null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PerformanceManager$notifyPhaseStarted$32 = false;
            String $i$a$-assert-PerformanceManager$notifyPhaseStarted$32 = "The measurement for phase " + (Object)((Object)this.currentPhaseType) + " must have been finished before starting " + (Object)((Object)newPhaseType);
            throw new AssertionError((Object)$i$a$-assert-PerformanceManager$notifyPhaseStarted$32);
        }
        if (!JsPlatformKt.isJs(this.targetPlatform)) {
            boolean bl3 = bl = newPhaseType.compareTo((Enum)this.currentPhaseType) >= 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "The measurement for phase " + (Object)((Object)newPhaseType) + " must be performed before " + (Object)((Object)this.currentPhaseType);
                throw new AssertionError((Object)string);
            }
        }
        this.phaseStartTime = this.currentTime();
        this.currentPhaseType = newPhaseType;
    }

    public final void notifyPhaseFinished(@NotNull PhaseType phaseType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        this.ensureNotFinalizedAndSameThread();
        boolean bl2 = bl = this.phaseStartTime != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The measurement for phase " + (Object)((Object)phaseType) + " hasn't been started or already finished";
            throw new AssertionError((Object)string);
        }
        this.finishPhase(phaseType);
    }

    public void notifyCompilationFinished() {
        this.ensureNotFinalizedAndSameThread();
        this.isFinalized = true;
        if (this.currentPhaseType != PhaseType.Backend || this.phaseStartTime != null) {
            this.hasErrors = true;
        }
        this.notifyCurrentPhaseFinishedIfNeeded();
        if (!this.isExtendedStatsEnabled) {
            return;
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.garbageCollectorMXBeans) {
            GarbageCollectionStats startGcMeasurement = (GarbageCollectionStats)MapsKt.getValue((Map)this.gcMeasurements, (Object)garbageCollectorMXBean.getName());
            Map map = this.gcMeasurements;
            String string = garbageCollectorMXBean.getName();
            String string2 = garbageCollectorMXBean.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            GarbageCollectionStats garbageCollectionStats = new GarbageCollectionStats(string2, garbageCollectorMXBean.getCollectionTime() - startGcMeasurement.getMillis(), garbageCollectorMXBean.getCollectionCount() - startGcMeasurement.getCount());
            map.put(string, garbageCollectionStats);
        }
        if (this.compilationMXBean != null && this.jitStartTime != null) {
            CompilationMXBean compilationMXBean = this.compilationMXBean;
            Intrinsics.checkNotNull((Object)compilationMXBean);
            long l2 = compilationMXBean.getTotalCompilationTime();
            Long l3 = this.jitStartTime;
            Intrinsics.checkNotNull((Object)l3);
            this.jitTimeMillis = l2 - l3;
        }
        if (!this.compilerType.isK2()) {
            PerformanceCounter.Companion.report((Function1<? super String, Unit>)((Function1)arg_0 -> PerformanceManager.notifyCompilationFinished$lambda$9(this, arg_0)));
        }
    }

    @PotentiallyIncorrectPhaseTimeMeasurement
    public final void notifyCurrentPhaseFinishedIfNeeded() {
        if (this.phaseStartTime != null) {
            this.finishPhase(this.currentPhaseType);
        }
    }

    private final void finishPhase(PhaseType phaseType) {
        if (phaseType != this.currentPhaseType) {
            boolean bl;
            boolean bl2 = bl = !this.phaseMeasurements.containsKey((Object)phaseType);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "The measurement for phase " + (Object)((Object)phaseType) + " is already performed";
                throw new AssertionError((Object)string);
            }
        }
        Map map = this.phaseMeasurements;
        Time time = (Time)this.phaseMeasurements.get((Object)phaseType);
        if (time == null) {
            time = Time.Companion.getZERO();
        }
        Time time2 = this.currentTime();
        Time time3 = this.phaseStartTime;
        Intrinsics.checkNotNull((Object)time3);
        Time time4 = time.plus(time2.minus(time3));
        map.put(phaseType, time4);
        this.phaseStartTime = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T measureSideTime$compiler_common(@NotNull PhaseSideType phaseSideType, @NotNull Function0<? extends T> block) {
        Object object;
        Map map;
        Time elapsedTime;
        Object object2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            this.ensureNotFinalizedAndSameThread();
            Time startTime = this.currentTime();
            try {
                object2 = block.invoke();
                elapsedTime = this.currentTime().minus(startTime);
                if (!this.isPhaseMeasuring()) break block7;
            }
            catch (Throwable throwable) {
                Object object3;
                Map map2;
                Time elapsedTime2 = this.currentTime().minus(startTime);
                if (this.isPhaseMeasuring()) {
                    map2 = this.phaseMeasurements;
                    object3 = this.currentPhaseType;
                    Time time = (Time)this.phaseMeasurements.get((Object)this.currentPhaseType);
                    if (time == null) {
                        time = Time.Companion.getZERO();
                    }
                    Time time2 = time.minus(elapsedTime2);
                    map2.put(object3, time2);
                }
                map2 = this.phaseSideMeasurements;
                SideStats sideStats = (SideStats)this.phaseSideMeasurements.get((Object)phaseSideType);
                if (sideStats == null) {
                    sideStats = SideStats.Companion.getEMPTY();
                }
                object3 = sideStats.plus(new SideStats(1, elapsedTime2));
                map2.put(phaseSideType, object3);
                throw throwable;
            }
            map = this.phaseMeasurements;
            object = this.currentPhaseType;
            Time time = (Time)this.phaseMeasurements.get((Object)this.currentPhaseType);
            if (time == null) {
                time = Time.Companion.getZERO();
            }
            Time time3 = time.minus(elapsedTime);
            map.put(object, time3);
        }
        map = this.phaseSideMeasurements;
        SideStats sideStats = (SideStats)this.phaseSideMeasurements.get((Object)phaseSideType);
        if (sideStats == null) {
            sideStats = SideStats.Companion.getEMPTY();
        }
        object = sideStats.plus(new SideStats(1, elapsedTime));
        map.put(phaseSideType, object);
        return (T)object2;
    }

    public final void dumpPerformanceReport(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        String string = this.createPerformanceReport(Intrinsics.areEqual((Object)FilesKt.getExtension((File)destination), (Object)"json"));
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FilesKt.writeBytes((File)destination, (byte[])byArray);
    }

    @NotNull
    public final String createPerformanceReport(boolean isJson) {
        String string;
        if (isJson) {
            string = UnitStatsJsonDumper.INSTANCE.dump(this.getUnitStats());
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$createPerformanceReport_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$createPerformanceReport_u24lambda_u2412.append(this.presentableName + " performance report\n");
            UnitStatsKt.forEachStringMeasurement(this.getUnitStats(), (Function1<? super String, Unit>)((Function1)arg_0 -> PerformanceManager.createPerformanceReport$lambda$12$lambda$11($this$createPerformanceReport_u24lambda_u2412, arg_0)));
            string = stringBuilder.toString();
        }
        return string;
    }

    private final void ensureNotFinalizedAndSameThread() {
        boolean bl;
        if (!JsPlatformKt.isJs(this.targetPlatform)) {
            boolean bl2 = bl = !this.isFinalized;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-PerformanceManager$ensureNotFinalizedAndSameThread$32 = false;
                String $i$a$-assert-PerformanceManager$ensureNotFinalizedAndSameThread$32 = "Cannot add a performance measurements because it's already finalized";
                throw new AssertionError((Object)$i$a$-assert-PerformanceManager$ensureNotFinalizedAndSameThread$32);
            }
        }
        Thread thread = Thread.currentThread();
        Thread thread2 = this.thread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"thread");
            thread2 = null;
        }
        bl = Intrinsics.areEqual((Object)thread, (Object)thread2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "PerformanceManager functions can be run only from the same thread";
            throw new AssertionError((Object)string);
        }
    }

    private static final UnitStats unitStats_delegate$lambda$1(PerformanceManager this$0) {
        if (!this$0.isFinalized) {
            this$0.notifyCompilationFinished();
        }
        Time initTime = null;
        Time analysisTime = null;
        Time translationToIrTime = null;
        Time irLoweringTime = null;
        Time backendTime = null;
        block11: for (Map.Entry entry : ((Map)this$0.phaseMeasurements).entrySet()) {
            PhaseType phaseType = (PhaseType)((Object)entry.getKey());
            Time time = (Time)entry.getValue();
            PhaseType phaseType2 = phaseType;
            switch (phaseType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[phaseType2.ordinal()]) {
                case 1: {
                    initTime = time;
                    continue block11;
                }
                case 2: {
                    analysisTime = time;
                    continue block11;
                }
                case 3: {
                    translationToIrTime = time;
                    continue block11;
                }
                case 4: {
                    irLoweringTime = time;
                    continue block11;
                }
                case 5: {
                    backendTime = time;
                    continue block11;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        SideStats findJavaClassStats = null;
        SideStats findKotlinClassStats = null;
        block12: for (Map.Entry entry : ((Map)this$0.phaseSideMeasurements).entrySet()) {
            PhaseSideType phaseSideType = (PhaseSideType)((Object)entry.getKey());
            SideStats sideStats = (SideStats)entry.getValue();
            PhaseSideType phaseSideType2 = phaseSideType;
            switch (phaseSideType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[phaseSideType2.ordinal()]) {
                case 1: {
                    findJavaClassStats = sideStats;
                    continue block12;
                }
                case 2: {
                    findKotlinClassStats = sideStats;
                    continue block12;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        String string = this$0.targetDescription;
        PlatformType platformType = this$0.getPlatformEnumValue(this$0.targetPlatform);
        CompilerType compilerType = this$0.compilerType;
        boolean bl = this$0.hasErrors;
        int n2 = this$0.files;
        int n3 = this$0.lines;
        Collection<GarbageCollectionStats> collection = this$0.gcMeasurements.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return new UnitStats(string, platformType, compilerType, bl, n2, n3, initTime, analysisTime, translationToIrTime, irLoweringTime, backendTime, findJavaClassStats, findKotlinClassStats, CollectionsKt.toList((Iterable)collection), this$0.jitTimeMillis, this$0.extendedStats);
    }

    private static final Unit addOtherUnitStats$lambda$2(PerformanceManager this$0, PhaseType phaseType, Time time) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseType), (String)"phaseType");
        if (time != null) {
            Map map = this$0.phaseMeasurements;
            Time time2 = (Time)this$0.phaseMeasurements.get((Object)phaseType);
            if (time2 == null) {
                time2 = Time.Companion.getZERO();
            }
            Time time3 = time2.plus(time);
            map.put(phaseType, time3);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addOtherUnitStats$lambda$3(PerformanceManager this$0, PhaseSideType phaseSideType, SideStats sideStats) {
        Intrinsics.checkNotNullParameter((Object)((Object)phaseSideType), (String)"phaseSideType");
        if (sideStats != null) {
            Map map = this$0.phaseSideMeasurements;
            SideStats sideStats2 = (SideStats)this$0.phaseSideMeasurements.get((Object)phaseSideType);
            if (sideStats2 == null) {
                sideStats2 = SideStats.Companion.getEMPTY();
            }
            SideStats sideStats3 = sideStats2.plus(sideStats);
            map.put(phaseSideType, sideStats3);
        }
        return Unit.INSTANCE;
    }

    private static final Unit notifyCompilationFinished$lambda$9(PerformanceManager this$0, String s2) {
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
        ((Collection)this$0.extendedStats).add(s2);
        return Unit.INSTANCE;
    }

    private static final Unit createPerformanceReport$lambda$12$lambda$11(StringBuilder $this_buildString, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_buildString.append(it).append('\n');
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PhaseType.values().length];
            try {
                nArray[PhaseType.Initialization.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Analysis.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.TranslationToIr.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.IrLowering.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseType.Backend.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PhaseSideType.values().length];
            try {
                nArray[PhaseSideType.FindJavaClass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PhaseSideType.BinaryClassFromKotlinFile.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

