/*
 *  arch/arm/mach-dw/include/mach/headset.h
 *
 *  Copyright (C) 2009 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_CRADLEDET_H
#define __ASM_ARCH_CRADLEDET_H

#include <linux/switch.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
#include <linux/device.h>
#include <linux/timer.h>
#include <linux/workqueue.h>

#define CRADLE_AUDIO         (1<<0)
#define CRADLE_CHARGER       (1<<1)

struct dwcradledet_config {
    unsigned int capability;
	unsigned int cradledetreg;
	unsigned int cradledetbitoffset;
	unsigned int irq;
	struct gpio_switch_platform_data  switch_platform_data;

};

typedef enum {
	kCradle_stat_OFF = 0,	// IMH Handset is Off-Cradle
	kCradle_stat_ON			// IMH Handset is On-Cradle
} eCradle_stat;


#ifndef ARGUSED
	#define ARGUSED(x) (void)(x)
#endif

struct cradledet_dev {
	unsigned int                dock_mute_gpio;
	unsigned int                pa_shutn_gpio;		
    int							board_version ;
    int 						cradle_state;
	spinlock_t                  cradle_state_lock;
    int							poll_period ;
	struct semaphore            poll_sem;
	int                         debouncetime;
    struct device               *g_dev;	
	struct device               dev;
    struct list_head            pCBfnQueue;
	spinlock_t                  pCBfnQueue_lock;
	struct timer_list           debouncetimer;
	unsigned int                capability;
	struct workqueue_struct		*cradledet_wq;
	struct work_struct		     cradledet_work;
	struct switch_dev            cradledet_sdev;
	const char                  *name_on;
	const char                  *name_off;
	const char                  *state_on;
	const char                  *state_off;	
};

struct cradledet_cb {
    void (*pCradleDetCBfn)(int);
	struct list_head list;
    
};

#define CRADLEDET_POLL_PERIOD				 130 // mSec
#define CRADLEDET_POLL_PERIOD_LOW_POWER		1000 // mSec
#define CRADLEDET_DEBOUNCE_PERIOD			  80 // mSec

/*TEL changes for Headset detection event*/
#define to_cradledet_device(obj) container_of(obj, struct cradledet_device, dev)

bool dw_cradledet_cb_register(void (*pfn)(int));
void dw_config_cradle_speakers( eCradle_stat  cradle_state,
							 bool          extra_debounce_delay,
							 uint          delay_ms );

int dw_cradledet_get_cradlestate(void);


#endif
