/*
 * include/video/ili9222fb.h
 *
 * Copyright (C) 2008 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __LINUX_INCLUDE_VIDEO_ILI9222FB_H
#define __LINUX_INCLUDE_VIDEO_ILI9222FB_H

enum ili9222fb_regs {
	ILI9222_START_OSCILLATION = 0x00,
	ILI9222_DRIVER_OUTPUT_CONTROL,
	ILI9222_LCD_AC_DRIVEING_CONTROL,
	ILI9222_ENTRY_MODE,
	ILI9222_COMPARE_REGISTER_1,
	ILI9222_COMPARE_REGISTER_2,
	ILI9222_DISPLAY_CONTROL_1 = 0x07,
	ILI9222_DISPLAY_CONTROL_2,
	ILI9222_DISPLAY_CONTROL_3,
	ILI9222_FRAME_CYCLE_CONTROL = 0x0B,
	ILI9222_EXTERNAL_DISPLAY_INTERFACE_CONTROL,
	ILI9222_POWER_CONTROL_1 = 0x10,
	ILI9222_POWER_CONTROL_2,
	ILI9222_POWER_CONTROL_3,
	ILI9222_POWER_CONTROL_4,
	ILI9222_RAM_ADDRESS_SET = 0x21,
	ILI9222_WRITE_DATA_TO_GRAM,
	ILI9222_B18_RAM_WRITE_MASK_1,
	ILI9222_B18_RAM_WRITE_MASK_2,
	ILI9222_GAMMA_CONTROL_1 = 0x30,
	ILI9222_GAMMA_CONTROL_2,
	ILI9222_GAMMA_CONTROL_3,
	ILI9222_GAMMA_CONTROL_4,
	ILI9222_GAMMA_CONTROL_5,
	ILI9222_GAMMA_CONTROL_6,
	ILI9222_GAMMA_CONTROL_7,
	ILI9222_GAMMA_CONTROL_8,
	ILI9222_GAMMA_CONTROL_9,
	ILI9222_GAMMA_CONTROL_10,
	ILI9222_GATE_SCAN_CONTROL = 0x40,
	ILI9222_VERTICAL_SCROLL_CONTROL,
	ILI9222_FIRST_SCREEN_DRIVE_POSITION,
	ILI9222_SECOND_SCREEN_DRIVE_POSITION,
	ILI9222_HORIZONTAL_RAM_ADRESS_POSITION,
	ILI9222_VERTICAL_RAM_ADDRESS_POSITION,
	ILI9222_OSCILLATOR_CONTROL_REGISTER = 0x4F,
	ILI9222_GENERAL_PURPOSE_IO = 0x60,
	ILI9222_OTP_VCM_PROGRAMMING,
	ILI9222_OTP_VCM_STATUS_AND_ENABLE,
	ILI9222_OTP_PROGRAMMING_ID_KEY = 0x65,
	ILI9222_DELAY = 0x8000,
};

struct ili9222fb_cmd {
	enum ili9222fb_regs reg;
	unsigned short val;
};

struct ili9222fb_pdata {
	unsigned int backlight_gpio;
};

#endif /* __LINUX_INCLUDE_VIDEO_ILI9222FB_H */
