/*
 * imh3-wm8978.c -- ASoC Machine Driver for DMW-96's IMH3 Rev 1 board
 * with Wolfson WM8978 and No input analog-switch.
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * 16 October, 2011:
 * Adapted to kernel 2.6.39 by Avi Miller <Avi.Miller@dspg.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//#define DEBUG
//#define V_DEBUG

#include <mach/gpio.h>
#include <sound/soc.h>
#include <sound/soc-dapm.h>

/*****************************************************************************/

#ifdef V_DEBUG
	#ifndef DEBUG 
		#define DEBUG
	#endif
	#define vdbg_prt(fmt, ...) \
		pr_debug("Imh3-WM78 asoc Mach-drv: %s(): " fmt, __func__, ##__VA_ARGS__)
#else
	#define vdbg_prt(fmt, ...)
#endif


#ifdef DEBUG
	#define dbg_prt(fmt, ...) \
		pr_debug("Imh3-WM78 asoc Mach-drv: %s(): " fmt, __func__, ##__VA_ARGS__)

	#define DIR_STR(stream_dir)  ((stream_dir == 0) ? "for Playback" : "for Capture")
#else
	#define dbg_prt(fmt, ...)	
	#define DIR_STR(stream_dir)
#endif

/*****************************************************************************/

#define DRIVER_NAME "snd-imh3-mach-drv"
#include "dspg-wm897X.c"

/* IMH3 board specific HW devices: */

static const char *pwramp_shutdn_st[] = {"shutdown", "active"};
static const struct soc_enum pwramp_shutdn_enum = SOC_ENUM_SINGLE_EXT(2, pwramp_shutdn_st);

static const char *pwramp_gain_st[] = {"+18db", "+6db"};
static const struct soc_enum pwramp_gain_enum = SOC_ENUM_SINGLE_EXT(2, pwramp_gain_st);

static const struct snd_kcontrol_new brd_audio_controls[] = {
	SOC_ENUM_EXT("Output-PwrAmp-Gain", pwramp_gain_enum,
		brd_get_pwramp_gain, brd_set_pwramp_gain),

	SOC_ENUM_EXT("Output-PwrAmp-Activation", pwramp_shutdn_enum,
		brd_get_pwramp_shutdn, brd_set_pwramp_shutdn),
};
static const size_t len_of_control_array = ARRAY_SIZE(brd_audio_controls);

static const struct snd_soc_dapm_widget brd_dapm_widgets[] = {
	SND_SOC_DAPM_MIC("Nokia-Headset-Mic-Jack", NULL),
	SND_SOC_DAPM_MIC("Onboard-Mic2", NULL),

	SND_SOC_DAPM_HP("Nokia-Headset-Ear-Jack", NULL),
	
	SND_SOC_DAPM_SPK("Earpiece", NULL),
	
	SND_SOC_DAPM_SPK("Speakers", brd_dapm_pwramp_shutdn),

	SND_SOC_DAPM_INPUT("Out-PwrAmp-L_IN"),
	SND_SOC_DAPM_INPUT("Out-PwrAmp-R_IN"),
	SND_SOC_DAPM_OUTPUT("Out-PwrAmp-L_OUT"),
	SND_SOC_DAPM_OUTPUT("Out-PwrAmp-R_OUT"),
};

static const size_t len_of_widget_array = ARRAY_SIZE(brd_dapm_widgets);

static const struct snd_soc_dapm_route brd_audio_route[] = {
	
	// sink, control, source (,connected)

	/* Output path: */
	
	/* Nokia Headset earphones connected to LOUT1, ROUT1 */
	{"Nokia-Headset-Ear-Jack", "NULL", "LOUT1"},
	{"Nokia-Headset-Ear-Jack", "NULL", "ROUT1"},
	
	/* Speakers connected via Power Amp to LOUT1, ROUT1  */
	{"Out-PwrAmp-L_IN", NULL, "LOUT1"},
	{"Out-PwrAmp-R_IN", NULL, "ROUT1"},

	{"Out-PwrAmp-L_OUT", "Output-PwrAmp-Activation", "Out-PwrAmp-L_IN"},
	{"Out-PwrAmp-R_OUT", "Output-PwrAmp-Activation", "Out-PwrAmp-R_IN"},

	{"Speakers", NULL, "Out-PwrAmp-L_OUT"},
	{"Speakers", NULL, "Out-PwrAmp-R_OUT"},

	/* Earpiece directly connected to OUT3, OUT4 */
	{"Earpiece", NULL, "OUT3"},
	{"Earpiece", NULL, "OUT4"},

	/* Input path: */

	/* Nokia Headset's Single-Ended Microphone */
	{ "Mic-Bias", NULL, "Nokia-Headset-Mic-Jack" },

	/* OnBoard Differential Microphone */
	{ "Mic-Bias", NULL, "Onboard-Mic2" },

	{ "LIN", NULL, "Mic-Bias" },
	{ "LIP", NULL, "Mic-Bias" },

	{ "RIN", NULL, "Mic-Bias" },
	{ "RIP", NULL, "Mic-Bias" },
};

static const size_t len_of_route_array = ARRAY_SIZE(brd_audio_route);


static const struct wm897X_setup_data hw_data_for_codec = {
	.use_tie_off = false,
};

static int check_valid_board( void )
{
	dbg_prt();

	/* Check for IMH3 board with Wolfson chip WM8978 */
	if ( dmw_board_is("imh3") &&
	     (!dmw_board_has_feature("wm8976") ||
	      dmw_board_has_feature("wm8978")) ) {
		printk("Assuming wm8978 sound device on imh3 board\n");
		return true;
	}

	return false;
}

