#include <stdio.h>
#include <windows.h>
#include "../conf/portability.h"
#include "../compat/lib/log.h"

#define CONTROL(a,b,c) if (!stricmp(argv[1],a)) {ControlCode = b; fprintf(stdout, c);}

static void usage();

void main(int argc,char *argv[])
{
	char szMsgPath[255];
	DWORD ControlCode;
	HANDLE hSCManager = NULL, hDomainNameService = NULL;
	SERVICE_STATUS ServiceStatus;
	
	if (argc != 2)		// wrong parameters given,
	{
		usage();		// give help (will NOT return)
		exit(1);
	}

	if ((hSCManager = OpenSCManager(NULL,NULL,SC_MANAGER_ALL_ACCESS)) == NULL)
	{
 		fprintf(stderr, "Unable to open Service Control Manager"
 						" database on local machine: %u\n", GetLastError());
		exit(1);
	}

  	if ((hDomainNameService = OpenService(hSCManager,TEXT("DomainNameService"),
  										 SERVICE_ALL_ACCESS)) == NULL)
    {
		fprintf(stderr,"Unable to open a handle to Domain Name Service: %u\n",
					   GetLastError());
		exit(1);
	}

	if (!stricmp(argv[1], "start"))
	{
		if(!StartService(hDomainNameService, 0, NULL))
		{
			if (GetLastError() == ERROR_SERVICE_ALREADY_RUNNING)
				fprintf(stderr, "Domain Name Service already running\n");
			else
				fprintf(stderr, "Unable to start the Domain Name Service: %u\n", GetLastError());
			exit(1);
		}
		fprintf(stdout, "Name Server Started\n");
		exit(0);

	}
	else CONTROL("stop",	SERVICE_CONTROL_STOP,		"Name Server Stopped\n")
	else CONTROL("restart", SERVICE_CONTROL_STOP,		"\n")
	else CONTROL("status",  SERVICE_CONTROL_INTERROGATE,"\n")
	else CONTROL("dumpdb",  SERVICE_CONTROL_DUMPDB,		"Dumping Database\n")	

    else CONTROL("reload",	SERVICE_CONTROL_RELOAD, 	"Reloading Database\n")
    else CONTROL("stats",	SERVICE_CONTROL_STATS,		"Dumping Statistics\n")
    else CONTROL("trace",	SERVICE_CONTROL_TRACE,		"Trace Level Incremented\n")
    else CONTROL("notrace",	SERVICE_CONTROL_NOTRACE,	"Tracing Cleared\n")
    else CONTROL("querylog",SERVICE_CONTROL_QRYLOG,		"QueryLogging Toggled\n")
    else CONTROL("qrylog"  ,SERVICE_CONTROL_QRYLOG,		"QueryLogging Toggled\n")
   	else { usage(); exit(1); }

	// now we know what the user wants to do, try submitting to service...
	if (!ControlService(hDomainNameService, ControlCode, &ServiceStatus))
	{
		fprintf(stderr, "Unable to send requested code to the Domain Name Service: %u\n", GetLastError());
		exit(1);
	}
	
	if (!stricmp(argv[1], "status"))
	{
  		printf("\nStatus of Domain Name Service:\n");
  		printf("  Service Type: 0x%x\n",ServiceStatus.dwServiceType);
  		printf("  Current State: 0x%x\n",ServiceStatus.dwCurrentState);
  		printf("  Controls Accepted: 0x%x\n",ServiceStatus.dwControlsAccepted);
  		printf("  Exit Code: %d\n", ServiceStatus.dwWin32ExitCode);
  		printf("  Service Specific Exit Code: %d\n",
  				  ServiceStatus.dwServiceSpecificExitCode);
  		printf("  Check Point: %d\n", ServiceStatus.dwCheckPoint);
  		printf("  Wait Hint: %d\n", ServiceStatus.dwWaitHint);
	}
	else if (!stricmp(argv[1], "restart"))
	{
		Sleep(5*1000);
		if (!StartService(hDomainNameService, 0, NULL))
		{
			fprintf(stderr, "Unable to restart the Domain Name Service: %u\n", GetLastError());
			exit(1);
		}
		fprintf(stdout, "Name Server Restarted\n");
	}
	exit(0);
}

static void usage()
{
	fprintf(stderr,"usage: ndc (status|dumpdb|reload|stats|trace|notrace\n"
				   "            |querylog|start|stop|restart)\n");
}

#endif
