/*
 * Decompiled with CFR 0.152.
 */
package mill.scalalib;

import java.io.Serializable;
import mill.api.Ctx;
import mill.api.PathRef;
import mill.api.PathRef$;
import mill.api.Result;
import mill.api.Result$;
import mill.define.Cacher;
import mill.define.Caller;
import mill.define.Ctx$;
import mill.define.NamedTask;
import mill.define.Target;
import mill.define.TargetImpl;
import mill.define.Task;
import mill.eval.EvaluatorPaths$;
import mill.moduledefs.Scaladoc;
import mill.package$;
import mill.scalalib.JavaModule;
import os.Path;
import os.PathChunk$;
import os.SubPath;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import upickle.default$;

@Scaladoc(value="/**\n * A trait holding methods for expressing deferred source generators,\n * which are useful for wiring in source-generation logic the output\n * of which can be predicted without execution.\n *\n * This is useful for preventing IDE-integration (BSP/Idea/Bloop) from\n * failing when the code-generation task fails for one reason or another.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005-aa\u0002\u0005\n!\u0003\r\tA\u0004\u0005\u0006;\u0001!\tA\b\u0005\u0006K\u0001!\tA\n\u0005\u0006\u0019\u0002!I!\u0014\u0005\u0006?\u0002!)\u0001\u0019\u0005\u0006Y\u0002!)!\u001c\u0005\u0006m\u0002!\t\u0001\u0019\u0005\u0006u\u0002!\t%\u001c\u0002\u001f\t\u00164WM\u001d:fI\u001e+g.\u001a:bi\u0016$7k\\;sG\u0016\u001cXj\u001c3vY\u0016T!AC\u0006\u0002\u0011M\u001c\u0017\r\\1mS\nT\u0011\u0001D\u0001\u0005[&dGn\u0001\u0001\u0014\u0007\u0001y\u0011\u0004\u0005\u0002\u0011-9\u0011\u0011\u0003F\u0007\u0002%)\u00111cC\u0001\u0007I\u00164\u0017N\\3\n\u0005U\u0011\u0012AB'pIVdW-\u0003\u0002\u00181\tI!)Y:f\u00072\f7o\u001d\u0006\u0003+I\u0001\"AG\u000e\u000e\u0003%I!\u0001H\u0005\u0003\u0015)\u000bg/Y'pIVdW-\u0001\u0004%S:LG\u000f\n\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t!QK\\5u\u0003q!WMZ3se\u0016$w)\u001a8fe\u0006$X\rZ*pkJ\u001cW\rV1tWN,\u0012a\n\t\u0004QA\u001adBA\u0015/\u001d\tQS&D\u0001,\u0015\taS\"\u0001\u0004=e>|GOP\u0005\u0002E%\u0011q&I\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0002TKFT!aL\u00111\u0005QJ\u0004cA\t6o%\u0011aG\u0005\u0002\n\u001d\u0006lW\r\u001a+bg.\u0004\"\u0001O\u001d\r\u0001\u0011I!HAA\u0001\u0002\u0003\u0015\ta\u000f\u0002\u0004?\u0012\n\u0014C\u0001\u001f@!\t\u0001S(\u0003\u0002?C\t9aj\u001c;iS:<\u0007C\u0001\u0011A\u0013\t\t\u0015EA\u0002B]fDCAA\"J\u0015B\u0011AiR\u0007\u0002\u000b*\u0011aiC\u0001\u000b[>$W\u000f\\3eK\u001a\u001c\u0018B\u0001%F\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A&\u0002\u0007+{#F\u000b\u0006!A\u0001R\u0003%\u0011\u0011tKR\u0004sN\u001a\u0011uCN\\7\u000f\t9s_\u0012,8-\u001b8hA\u001d,g.\u001a:bi\u0016$\u0007eY8eK:\u0002C\u000b[3!I&4g-\u001a:f]\u000e,\u0007EY3uo\u0016,g\u000e\t;iSN\u0004\u0013M\u001c3\u000bA\u0001\u0002#\u0006I.\\O\u0016tWM]1uK\u0012\u001cv.\u001e:dKNlV\f\t7jKN\u0004\u0013N\u001c\u0011uQ\u0016\u0004c-Y2uAQD\u0017\r\u001e\u0011J\t\u0016k#/\u001a7bi\u0016$\u0007\u0005^1tWNT\u0001\u0005\t\u0011+A!\u00125\u000bU\u0018CY>|\u0007oL$f]&#W-Y\u0015!o&dG\u000e\t8pi\u0002\u0012XO\u001c\u0011uQ\u0016\u0004C/Y:lg2\u0002#-\u001e;!o&dG\u000eI;tK\u0002\"\b.Z7!i>\u00043\u000f^1uS\u000e\fG\u000e\\=\u000bA\u0001\u0002#\u0006\t3fi\u0016\u0014X.\u001b8fAQDW\r\t7pG\u0006$\u0018n\u001c8!_\u001a\u0004C\u000f[3!g>,(oY3!G>$W\r\t;iKf\u0004s/\u001b7mAA\u0014x\u000eZ;dK\u0002\u0012\u0017\u0010\t7p_.Lgn\u001a\u0011va\u0002\"\b.Z5s\u0015\u0001\u0002\u0003E\u000b\u0011\\7R\u000b7o[\u0012eK\u001a,'O]3e\u000f\u0016tWM]1uK\u0012\u001cv.\u001e:dKJ{w\u000e^:^;2\u00023N\\8xS:<\u0007\u0005\u001e5bi\u0002\"\b.Z:fAI|w\u000e^:!o&dG\u000e\t2fAA\u0014Xm]3oi\u0002*h\u000eZ3s\u0015\u0001\u0002\u0003E\u000b\u0011uQ\u0016\u0004C-Z:uA\u0011L'/Z2u_JLWm\u001d\u0011p]\u000e,\u0007\u0005\u001e5fAQ\f7o\u001b\u0011jg\u0002\u0012XO\u001c\u0018\u000bA\u0001\u0002#fL\u0001\u001caJ,G-[2u\u000f\u0016tWM]1uK\u0012\u001cv.\u001e:dKJ{w\u000e^:\u0015\u00059CFCA(W!\rA\u0003\u0007\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006\u0011qn]\u0005\u0003+J\u0013A\u0001U1uQ\")qk\u0001a\u0001!\u0006\u0019q.\u001e;\t\u000be\u001b\u0001\u0019\u0001.\u0002\tQ\f7o\u001b\u0019\u00037v\u00032!E\u001b]!\tAT\fB\u0005_1\u0006\u0005\t\u0011!B\u0001w\t\u0019q\f\n\u001a\u00023A\u0014X\rZ5di\u0016$w)\u001a8fe\u0006$X\rZ*pkJ\u001cWm]\u000b\u0002CB\u0019!MZ(\u000f\u0005\r,gB\u0001\u0016e\u0013\u0005a\u0011BA\u0018\f\u0013\t9\u0007NA\u0001U\u0015\ty3\u0002\u000b\u0003\u0005\u0007&S\u0017%A6\u0002\u0003\u0013z#F\u000b\u0006!A\u0001R\u0003eQ8naV$Xm\u001d\u0011uQ\u0016\u0004C.[:uA=4\u0007e]8ve\u000e,\u0007E]8piN\u0004C\u000f[1uA]LG\u000e\u001c\u0011cK\u0002\u0002(o\u001c3vG\u0016$\u0007EY=!7n#WMZ3se\u0016$w)\u001a8fe\u0006$X\rZ*pkJ\u001cW\rV1tWNlV\fI<ji\"|W\u000f\u001e\u0006!A\u0001R\u0003%Y2uk\u0006dG.\u001f\u0011sk:t\u0017N\\4!i\",\u0007eZ3oKJ\fGo\u001c:tA%t\u0007%];fgRLwN\u001c\u0018\u000bA\u0001\u0002#fL\u0001\u0019I\u00164WM\u001d:fI\u001e+g.\u001a:bi\u0016$7k\\;sG\u0016\u001cX#\u00018\u0011\u0007\t4w\u000eE\u0002)aA\u0004\"AY9\n\u0005ID'a\u0002)bi\"\u0014VM\u001a\u0015\u0005\u000b\rKE/I\u0001v\u0003\u0005]rF\u000b\u0016\u000bA\u0001\u0002#\u0006\t*v]N\u0004C\u000f[3!Y\u0006T\u0018\u0010I:pkJ\u001cW\rI4f]\u0016\u0014\u0018\r^8sg2\u0002#/\u001a;ve:Lgn\u001a\u0011sK\u001a,'/\u001a8dKN\u0004Co\u001c\u0011uQ\u0016\u0004S\r\u001f9b]\u0012,G\rI4f]\u0016\u0014\u0018\r^3eAM|WO]2fAI|w\u000e^:\u000bA\u0001\u0002#\u0006\t;iKf\u0004\u0013M]3!gV\u0004\bo\\:fI\u0002\"x\u000e\t5bm\u0016\u0004sO]5ui\u0016t\u0007eY8eK\u0002JgN\f\u0006!A\u0001Rs&\u0001\u0006jI\u0016\u001cv.\u001e:dKNDCAB\"Jq\u0006\n\u00110AA%_)R#\u0002\t\u0011!U\u0001\"\u0016m]6!i\"\fG\u000fI%E\u000b6\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\"\u0018m]6tAMDw.\u001e7eAI,G.\u001f\u0011p]2\u0002\u0013m\u001d\u0011uQ\u0016L\b%\u0019<pS\u0012\u0004S-Y4fe2L(\u0002\t\u0011!U\u0001\u0012XO\u001c8j]\u001e\u00043o\\;sG\u0016\u0004s-\u001a8fe\u0006$xN]:!e\u00164WM]3oG\u0016$\u0007EY=!7n#WMZ3se\u0016$w)\u001a8fe\u0006$X\rZ*pkJ\u001cW\rV1tWNlVL\u0003\u0011!A)z\u0013AC1mYN{WO]2fg\"\"\u0001aQ%}C\u0005i\u0018A!,0U)R\u0001E\u000b\u0011BAQ\u0014\u0018-\u001b;!Q>dG-\u001b8hA5,G\u000f[8eg\u00022wN\u001d\u0011fqB\u0014Xm]:j]\u001e\u0004C-\u001a4feJ,G\rI:pkJ\u001cW\rI4f]\u0016\u0014\u0018\r^8sg2R\u0001E\u000b\u0011xQ&\u001c\u0007\u000eI1sK\u0002*8/\u001a4vY\u00022wN\u001d\u0011xSJLgn\u001a\u0011j]\u0002\u001ax.\u001e:dK6:WM\\3sCRLwN\u001c\u0011m_\u001eL7\r\t;iK\u0002zW\u000f\u001e9vi*\u0001#\u0006I8gA]D\u0017n\u00195!G\u0006t\u0007EY3!aJ,G-[2uK\u0012\u0004s/\u001b;i_V$\b%\u001a=fGV$\u0018n\u001c8/\u0015\u0001R#\u0002\t\u0016!)\"L7\u000fI5tAU\u001cXMZ;mA\u0019|'\u000f\t9sKZ,g\u000e^5oO\u0002JE)R\u0017j]R,wM]1uS>t\u0007\u0005\u000b\"T!>JE-Z10\u00052|w\u000e]\u0015!MJ|WN\u0003\u0011+A\u0019\f\u0017\u000e\\5oO\u0002:\b.\u001a8!i\",\u0007eY8eK6:WM\\3sCRLwN\u001c\u0011uCN\\\u0007EZ1jYN\u0004cm\u001c:!_:,\u0007E]3bg>t\u0007e\u001c:!C:|G\u000f[3s])\u0001#f\f\u0015\u0003\u0001}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bY\u0011aA1qS&!\u0011\u0011BA\u0002\u00051)\u0007\u0010]3sS6,g\u000e^1m\u0001")
public interface DeferredGeneratedSourcesModule
extends JavaModule {
    public static /* synthetic */ Seq deferredGeneratedSourceTasks$(DeferredGeneratedSourcesModule $this) {
        return $this.deferredGeneratedSourceTasks();
    }

    @Scaladoc(value="/**\n   * A set of tasks producing generated code. The difference between this and\n   * [[generatedSources]] lies in the fact that IDE-related tasks\n   * (BSP/Bloop/GenIdea) will not run the tasks, but will use them to statically\n   * determine the location of the source code they will produce by looking up their\n   * [[Task#deferredGeneratedSourceRoots]], knowing that these roots will be present under\n   * the dest directories once the task is run.\n   */")
    default public Seq<NamedTask<?>> deferredGeneratedSourceTasks() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private Seq<Path> predictGeneratedSourceRoots(NamedTask<?> task, Path out) {
        Path dest = EvaluatorPaths$.MODULE$.resolveDestPaths(out, task).dest();
        Seq<SubPath> explicitSourceRoots = ((Task)((Object)task)).deferredGeneratedSourceRoots();
        if (explicitSourceRoots.isEmpty()) {
            return new $colon$colon<Nothing$>((Nothing$)((Object)dest), Nil$.MODULE$);
        }
        return (Seq)explicitSourceRoots.map((Function1<SubPath, Path> & Serializable)subPath -> dest.$div(PathChunk$.MODULE$.SubPathChunk((SubPath)subPath)));
    }

    public static /* synthetic */ Target predictedGeneratedSources$(DeferredGeneratedSourcesModule $this) {
        return $this.predictedGeneratedSources();
    }

    @Scaladoc(value="/**\n   * Computes the list of source roots that will be produced by [[deferredGeneratedSourceTasks]] without\n   * actually running the generators in question.\n   */")
    default public Target<Seq<Path>> predictedGeneratedSources() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.T().traverseCtx((Seq)Nil$.MODULE$, (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> {
            Path out = package$.MODULE$.T().out((Ctx)ctx$macro$2);
            return (Seq)this.deferredGeneratedSourceTasks().flatMap((Function1<NamedTask, Seq> & Serializable)t -> this.predictGeneratedSourceRoots((NamedTask<?>)t, out));
        })), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#predictedGeneratedSources"), new Line(43), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/DeferredGeneratedSourcesModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(package$.MODULE$.pathReadWrite(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(package$.MODULE$.pathReadWrite())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#predictedGeneratedSources"));
    }

    public static /* synthetic */ Target deferredGeneratedSources$(DeferredGeneratedSourcesModule $this) {
        return $this.deferredGeneratedSources();
    }

    @Scaladoc(value="/**\n   * Runs the lazy source generators, returning references to the expanded generated source roots\n   * they are supposed to have written code in.\n   */")
    default public Target<Seq<PathRef>> deferredGeneratedSources() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.T().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)package$.MODULE$.T().sequence((Seq)this.deferredGeneratedSourceTasks().map((Function1<Target, Task> & Serializable)t -> ((Task.Ops)((Object)t)).map((Function1<Object, Function1> & Serializable)x$1 -> (Function1<Path, Seq> & Serializable)out -> this.predictGeneratedSourceRoots((NamedTask<?>)t, (Path)out))))), Nil$.MODULE$), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> {
            Path out = package$.MODULE$.T().out((Ctx)ctx$macro$2);
            return (Seq)((IterableOps)((Seq)items$macro$1.apply(false)).flatMap((Function1<Function1, Seq> & Serializable)x$2 -> (Seq)x$2.apply(out))).map((Function1<Path, PathRef> & Serializable)x$3 -> package$.MODULE$.PathRef().apply((Path)x$3, package$.MODULE$.PathRef().apply$default$2(), package$.MODULE$.PathRef().apply$default$3()));
        })), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#deferredGeneratedSources"), new Line(52), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/DeferredGeneratedSourcesModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(PathRef$.MODULE$.jsonFormatter(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(PathRef$.MODULE$.jsonFormatter())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#deferredGeneratedSources"));
    }

    public static /* synthetic */ Target ideSources$(DeferredGeneratedSourcesModule $this) {
        return $this.ideSources();
    }

    @Scaladoc(value="/**\n   * Task that IDE-configuration tasks should rely on, as they avoid eagerly\n   * running source generators referenced by [[deferredGeneratedSourceTasks]]\n   */")
    default public Target<Seq<Path>> ideSources() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.Task().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)this.sources()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.generatedSources()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.predictedGeneratedSources()), Nil$.MODULE$))), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> (Seq)((IterableOps)((IterableOps)((Seq)items$macro$1.apply(false)).map((Function1<PathRef, Path> & Serializable)x$4 -> x$4.path())).$plus$plus((IterableOnce)((Seq)items$macro$1.apply(true)).map((Function1<PathRef, Path> & Serializable)x$5 -> x$5.path()))).$plus$plus((Seq)items$macro$1.apply(2)))), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#ideSources"), new Line(66), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/DeferredGeneratedSourcesModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(package$.MODULE$.pathReadWrite(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(package$.MODULE$.pathReadWrite())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#ideSources"));
    }

    public static /* synthetic */ Target allSources$(DeferredGeneratedSourcesModule $this) {
        return $this.allSources();
    }

    @Override
    default public Target<Seq<PathRef>> allSources() {
        return (Target)((Cacher)((Object)this)).cachedTarget((Function0<TargetImpl> & Serializable)() -> new TargetImpl(package$.MODULE$.Task().traverseCtx(new $colon$colon<Nothing$>((Nothing$)((Object)this.sources()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.generatedSources()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.deferredGeneratedSources()), Nil$.MODULE$))), (Function2<Seq, Ctx, Result> & Serializable)(items$macro$1, ctx$macro$2) -> Result$.MODULE$.create((Function0<Seq> & Serializable)() -> (Seq)((IterableOps)((Seq)items$macro$1.apply(false)).$plus$plus((Seq)items$macro$1.apply(true))).$plus$plus((Seq)items$macro$1.apply(2)))), Ctx$.MODULE$.make(new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#allSources"), new Line(69), this.millModuleBasePath(), this.millModuleSegments(), this.millModuleExternal(), this.millModuleShared(), new File("/home/runner/work/mill/mill/scalalib/src/mill/scalalib/DeferredGeneratedSourcesModule.scala"), new Caller(this)), default$.MODULE$.ReadWriter().join(default$.MODULE$.SeqLikeReader(PathRef$.MODULE$.jsonFormatter(), Seq$.MODULE$.iterableFactory()), default$.MODULE$.SeqLikeWriter(PathRef$.MODULE$.jsonFormatter())), (Option<Object>)new Some<Object>(BoxesRunTime.boxToBoolean(false))), new Enclosing("mill.scalalib.DeferredGeneratedSourcesModule#allSources"));
    }

    public static void $init$(DeferredGeneratedSourcesModule $this) {
    }
}

