/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.internal.ConfigureUtil;

public class DeprecatedProcessOperations {
    @Nullable
    private final Class<?> owner;
    private final ProcessOperations processOperations;

    public DeprecatedProcessOperations(Class<?> owner, ProcessOperations processOperations) {
        this.owner = owner;
        this.processOperations = processOperations;
    }

    public DeprecatedProcessOperations(ProcessOperations processOperations) {
        this.owner = null;
        this.processOperations = processOperations;
    }

    public ExecResult javaexec(Closure<?> closure) {
        this.nagUser("javaexec(Closure)", "ExecOperations.javaexec(Action) or ProviderFactory.javaexec(Action)");
        return this.processOperations.javaexec((Action<? super JavaExecSpec>)ConfigureUtil.configureUsing(closure));
    }

    private void nagUser(String method, String replacement) {
        DeprecationMessageBuilder.DeprecateInvocation builder = this.owner != null ? DeprecationLogger.deprecateMethod(this.owner, (String)method) : DeprecationLogger.deprecateInvocation((String)method);
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.WithReplacement)builder.withAdvice("Use " + replacement + " instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_project_exec")).nagUser();
    }

    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        this.nagUser("javaexec(Action)", "ExecOperations.javaexec(Action) or ProviderFactory.javaexec(Action)");
        return this.processOperations.javaexec(action);
    }

    public ExecResult exec(Closure<?> closure) {
        this.nagUser("exec(Closure)", "ExecOperations.exec(Action) or ProviderFactory.exec(Action)");
        return this.processOperations.exec((Action<? super ExecSpec>)ConfigureUtil.configureUsing(closure));
    }

    public ExecResult exec(Action<? super ExecSpec> action) {
        this.nagUser("exec(Action)", "ExecOperations.exec(Action) or ProviderFactory.exec(Action)");
        return this.processOperations.exec(action);
    }
}

