/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb.SmbComReadAndX;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.TransPeekNamedPipe;
import jcifs.smb.TransPeekNamedPipeResponse;
import jcifs.util.LogStream;
import jcifs.util.transport.TransportException;

public class SmbFileInputStream
extends InputStream {
    private long fp;
    private int readSize;
    private int openFlags;
    private int access;
    private byte[] tmp = new byte[1];
    SmbFile file;

    public SmbFileInputStream(String url) throws SmbException, MalformedURLException, UnknownHostException {
        this(new SmbFile(url));
    }

    public SmbFileInputStream(SmbFile file) throws SmbException, MalformedURLException, UnknownHostException {
        this(file, 1);
    }

    SmbFileInputStream(SmbFile file, int openFlags) throws SmbException, MalformedURLException, UnknownHostException {
        this.file = file;
        this.openFlags = openFlags & 0xFFFF;
        this.access = openFlags >>> 16 & 0xFFFF;
        if (file.type != 16) {
            file.open(openFlags, this.access, 128, 0);
            this.openFlags &= 0xFFFFFFAF;
        } else {
            file.connect0();
        }
        this.readSize = Math.min(file.tree.session.transport.rcv_buf_size - 70, file.tree.session.transport.server.maxBufferSize - 70);
    }

    protected IOException seToIoe(SmbException se) {
        IOException ioe = se;
        Throwable root = se.getRootCause();
        if (root instanceof TransportException) {
            ioe = (TransportException)root;
            root = ((TransportException)ioe).getRootCause();
        }
        if (root instanceof InterruptedException) {
            ioe = new InterruptedIOException(root.getMessage());
            ioe.initCause(root);
        }
        return ioe;
    }

    public void close() throws IOException {
        try {
            this.file.close();
            this.tmp = null;
        }
        catch (SmbException se) {
            throw this.seToIoe(se);
        }
    }

    public int read() throws IOException {
        if (this.read(this.tmp, 0, 1) == -1) {
            return -1;
        }
        return this.tmp[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readDirect(b, off, len);
    }

    public int readDirect(byte[] b, int off, int len) throws IOException {
        int r;
        int n;
        if (len <= 0) {
            return 0;
        }
        long start = this.fp;
        if (this.tmp == null) {
            throw new IOException("Bad file descriptor");
        }
        this.file.open(this.openFlags, this.access, 128, 0);
        if (LogStream.level >= 4) {
            SmbFile.log.println("read: fid=" + this.file.fid + ",off=" + off + ",len=" + len);
        }
        SmbComReadAndXResponse response = new SmbComReadAndXResponse(b, off);
        if (this.file.type == 16) {
            response.responseTimeout = 0L;
        }
        do {
            r = len > this.readSize ? this.readSize : len;
            if (LogStream.level >= 4) {
                SmbFile.log.println("read: len=" + len + ",r=" + r + ",fp=" + this.fp);
            }
            try {
                SmbComReadAndX request = new SmbComReadAndX(this.file.fid, this.fp, r, null);
                if (this.file.type == 16) {
                    request.remaining = 1024;
                    request.maxCount = 1024;
                    request.minCount = 1024;
                }
                this.file.send(request, response);
            }
            catch (SmbException se) {
                if (this.file.type == 16 && se.getNtStatus() == -1073741493) {
                    return -1;
                }
                throw this.seToIoe(se);
            }
            n = response.dataLength;
            if (n <= 0) {
                return (int)(this.fp - start > 0L ? this.fp - start : -1L);
            }
            this.fp += (long)n;
            response.off += n;
        } while ((len -= n) > 0 && n == r);
        return (int)(this.fp - start);
    }

    public int available() throws IOException {
        if (this.file.type != 16) {
            return 0;
        }
        try {
            SmbNamedPipe pipe = (SmbNamedPipe)this.file;
            this.file.open(32, pipe.pipeType & 0xFF0000, 128, 0);
            TransPeekNamedPipe req = new TransPeekNamedPipe(this.file.unc, this.file.fid);
            TransPeekNamedPipeResponse resp = new TransPeekNamedPipeResponse(pipe);
            pipe.send(req, resp);
            if (resp.status == 1 || resp.status == 4) {
                this.file.opened = false;
                return 0;
            }
            return resp.available;
        }
        catch (SmbException se) {
            throw this.seToIoe(se);
        }
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            this.fp += n;
            return n;
        }
        return 0L;
    }
}

