/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.module.SourceReaderModule;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.SubjectSchemeReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.dita.dost.writer.DebugFilter;
import org.dita.dost.writer.DitaWriterFilter;
import org.dita.dost.writer.NormalizeFilter;
import org.dita.dost.writer.ProfilingFilter;
import org.dita.dost.writer.TopicFragmentFilter;
import org.dita.dost.writer.ValidationFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class DebugAndFilterModule
extends SourceReaderModule {
    private Configuration.Mode processingMode;
    private boolean genDebugInfo;
    private boolean setSystemId;
    private boolean profilingEnabled;
    private String transtype;
    private File ditavalFile;
    private FilterUtils filterUtils;
    private File outputFile;
    private Map<QName, Map<String, Set<String>>> validateMap;
    private Map<QName, Map<String, String>> defaultValueMap;
    private URI currentFile;
    private List<URI> resources;
    private Map<URI, Set<URI>> dic;
    private SubjectSchemeReader subjectSchemeReader;
    private FilterUtils baseFilterUtils;
    private DitaWriterFilter ditaWriterFilter;
    private TypeFilter typeFilter;
    private TopicFragmentFilter topicFragmentFilter;
    private TempFileNameScheme tempFileNameScheme;

    @Override
    public void setJob(Job job) {
        super.setJob(job);
        try {
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(job.getProperty("temp-file-name-scheme")).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(job.getInputDir());
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        if (this.logger == null) {
            throw new IllegalStateException("Logger not set");
        }
        try {
            this.readArguments(input);
            this.init();
            this.job.getFileInfo().stream().filter(f -> GenListModuleReader.isFormatDita(f.format) || "ditamap".equals(f.format)).forEach(this::processFile);
            this.job.write();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DITAOTException("Exception doing debug and filter module processing: " + e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(Job.FileInfo f) {
        this.currentFile = f.src;
        if (f.src == null || !URLUtils.exists(f.src) || !f.src.equals(f.result)) {
            this.logger.warn("Ignoring a copy-to file " + String.valueOf(f.result));
            return;
        }
        if (f.uri.isAbsolute() && !f.uri.toString().startsWith(this.job.tempDirURI.toString())) {
            throw new RuntimeException("Cannot write outside of the temporary files folder: " + String.valueOf(f.uri));
        }
        this.outputFile = new File(this.job.tempDirURI.resolve(f.uri));
        this.logger.info("Processing " + String.valueOf(f.src) + " to " + String.valueOf(this.outputFile.toURI()));
        Set<URI> schemaSet = this.dic.get(f.uri);
        if (schemaSet != null && !schemaSet.isEmpty()) {
            this.logger.debug("Loading subject schemes");
            this.subjectSchemeReader.reset();
            for (URI schema : schemaSet) {
                this.subjectSchemeReader.loadSubjectScheme(new File(this.job.tempDirURI.resolve(schema.getPath() + ".subm")));
            }
            this.validateMap = this.subjectSchemeReader.getValidValuesMap();
            this.defaultValueMap = this.subjectSchemeReader.getDefaultValueMap();
        } else {
            this.validateMap = Collections.emptyMap();
            this.defaultValueMap = Collections.emptyMap();
        }
        if (this.profilingEnabled) {
            this.filterUtils = this.baseFilterUtils.refine(this.subjectSchemeReader.getSubjectSchemeMap());
        }
        InputSource in = null;
        try {
            XMLReader parser;
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(this.currentFile.toString(), this.logger, this.processingMode));
            XMLReader xmlSource = parser = XMLUtils.getXmlReader(f.format, this.processingMode).orElse(this.reader);
            for (XMLFilter filter : this.getProcessingPipe(this.currentFile)) {
                filter.setParent(xmlSource);
                xmlSource = filter;
            }
            xmlSource.setContentHandler(null);
            try {
                DTDForwardHandler lexicalHandler = new DTDForwardHandler(xmlSource);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                parser.setFeature("http://xml.org/sax/features/lexical-handler", true);
            }
            catch (SAXNotRecognizedException lexicalHandler) {
                // empty catch block
            }
            in = new InputSource(f.src.toString());
            ContentHandler result = this.job.getStore().getContentHandler(this.outputFile.toURI());
            xmlSource.setContentHandler(result);
            xmlSource.parse(in);
            try {
                XMLUtils.close(in);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        catch (RuntimeException e) {
            throw e;
            catch (Exception e2) {
                this.logger.error(e2.getMessage(), e2);
            }
        }
        finally {
            try {
                XMLUtils.close(in);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        if (!GenListModuleReader.isFormatDita(f.format)) return;
        if (this.typeFilter.getDitaClass() == null) {
            f.format = "dita";
            return;
        }
        if (Constants.MAP_MAP.matches(this.typeFilter.getDitaClass())) {
            f.format = "ditamap";
            return;
        }
        f.format = "dita";
    }

    private void init() throws IOException, DITAOTException, SAXException {
        this.initXmlReader();
        this.subjectSchemeReader = new SubjectSchemeReader();
        this.subjectSchemeReader.setLogger(this.logger);
        this.subjectSchemeReader.setJob(this.job);
        this.outputSubjectScheme();
        this.dic = this.subjectSchemeReader.readMapFromXML(new File(this.job.tempDir, "subject_scheme.dictionary"));
        if (this.profilingEnabled) {
            DitaValReader filterReader = new DitaValReader();
            filterReader.setLogger(this.logger);
            filterReader.setJob(this.job);
            if (this.job.getStore().exists(this.ditavalFile.toURI())) {
                filterReader.read(this.ditavalFile.getAbsoluteFile());
                this.baseFilterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype), filterReader.getFilterMap(), filterReader.getForegroundConflictColor(), filterReader.getBackgroundConflictColor());
            } else {
                this.baseFilterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype));
            }
            this.baseFilterUtils.setLogger(this.logger);
        }
        this.initFilters();
    }

    private void initFilters() {
        this.ditaWriterFilter = new DitaWriterFilter();
        this.ditaWriterFilter.setLogger(this.logger);
        this.ditaWriterFilter.setJob(this.job);
        this.ditaWriterFilter.setEntityResolver(this.reader.getEntityResolver());
        this.topicFragmentFilter = new TopicFragmentFilter("conref", "conrefend");
        this.typeFilter = new TypeFilter();
        this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
    }

    @Override
    List<XMLFilter> getProcessingPipe(URI fileToParse) {
        ArrayList<XMLFilter> pipe = new ArrayList<XMLFilter>();
        if (this.genDebugInfo) {
            DebugFilter debugFilter = new DebugFilter();
            debugFilter.setLogger(this.logger);
            debugFilter.setCurrentFile(this.currentFile);
            pipe.add(debugFilter);
        }
        if (this.filterUtils != null) {
            ProfilingFilter profilingFilter = new ProfilingFilter();
            profilingFilter.setLogger(this.logger);
            profilingFilter.setJob(this.job);
            profilingFilter.setFilterUtils(this.filterUtils);
            profilingFilter.setCurrentFile(fileToParse);
            pipe.add(profilingFilter);
        }
        ValidationFilter validationFilter = new ValidationFilter();
        validationFilter.setLogger(this.logger);
        validationFilter.setValidateMap(this.validateMap);
        validationFilter.setCurrentFile(fileToParse);
        validationFilter.setJob(this.job);
        validationFilter.setProcessingMode(this.processingMode);
        pipe.add(validationFilter);
        NormalizeFilter normalizeFilter = new NormalizeFilter();
        normalizeFilter.setLogger(this.logger);
        pipe.add(normalizeFilter);
        pipe.add(this.topicFragmentFilter);
        pipe.addAll(super.getProcessingPipe(fileToParse));
        pipe.add(this.typeFilter);
        this.ditaWriterFilter.setDefaultValueMap(this.defaultValueMap);
        this.ditaWriterFilter.setCurrentFile(this.currentFile);
        this.ditaWriterFilter.setOutputFile(this.outputFile);
        pipe.add(this.ditaWriterFilter);
        return pipe;
    }

    private void readArguments(AbstractPipelineInput input) {
        this.transtype = input.getAttribute("transtype");
        this.profilingEnabled = true;
        if (input.getAttribute("profiling.enable") != null) {
            this.profilingEnabled = Boolean.parseBoolean(input.getAttribute("profiling.enable"));
        }
        if (this.profilingEnabled) {
            this.ditavalFile = new File(this.job.tempDir, "ditaot.generated.ditaval");
        }
        this.gramcache = "yes".equalsIgnoreCase(input.getAttribute("gramcache"));
        this.validate = Boolean.parseBoolean(input.getAttribute("validate"));
        this.setSystemId = "yes".equals(input.getAttribute("setsystemid"));
        this.genDebugInfo = Boolean.parseBoolean(input.getAttribute("generate-debug-attributes"));
        String mode = input.getAttribute("processing-mode");
        this.processingMode = mode != null ? Configuration.Mode.valueOf(mode.toUpperCase()) : Configuration.Mode.LAX;
        this.resources = input.getAttribute("resources") != null ? Stream.of(input.getAttribute("resources").split(File.pathSeparator)).map(resource -> new File((String)resource).toURI()).collect(Collectors.toList()) : Collections.emptyList();
    }

    private void outputSubjectScheme() throws DITAOTException {
        try {
            Map<URI, Set<URI>> graph = this.subjectSchemeReader.readMapFromXML(new File(this.job.tempDir, "subrelation.xml"));
            LinkedList<URI> queue = new LinkedList<URI>(graph.keySet());
            HashSet<URI> visitedSet = new HashSet<URI>();
            while (!queue.isEmpty()) {
                Document parentRoot;
                URI parent = (URI)queue.poll();
                Set<URI> children = graph.get(parent);
                if (children != null) {
                    queue.addAll(children);
                }
                if (GenListModuleReader.ROOT_URI.equals(parent) || visitedSet.contains(parent)) continue;
                visitedSet.add(parent);
                File tmprel = new File(String.valueOf(FileUtils.resolve(this.job.tempDir, parent)) + ".subm");
                if (!tmprel.exists()) {
                    URI src = this.job.getFileInfo((URI)parent).src;
                    parentRoot = this.job.getStore().getDocument(src);
                } else {
                    parentRoot = this.job.getStore().getDocument(tmprel.toURI());
                }
                if (children != null) {
                    for (URI childpath : children) {
                        Document childRoot = this.job.getStore().getImmutableDocument(this.job.getInputFile().resolve(childpath.getPath()));
                        this.mergeScheme(parentRoot, childRoot);
                        this.generateScheme(new File(this.job.tempDir, childpath.getPath() + ".subm"), childRoot);
                    }
                }
                this.generateScheme(new File(this.job.tempDir, parent.getPath() + ".subm"), parentRoot);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new DITAOTException(e);
        }
    }

    private void mergeScheme(Document parentRoot, Document childRoot) {
        LinkedList<Element> pQueue = new LinkedList<Element>();
        pQueue.offer(parentRoot.getDocumentElement());
        while (!pQueue.isEmpty()) {
            Node tmpnode;
            int i;
            Element target;
            Element pe = (Element)pQueue.poll();
            NodeList pList = pe.getChildNodes();
            for (int i2 = 0; i2 < pList.getLength(); ++i2) {
                Node node = pList.item(i2);
                if (node.getNodeType() != 1) continue;
                pQueue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !Constants.SUBJECTSCHEME_SUBJECTDEF.matches(value)) continue;
            value = pe.getAttribute("keyref");
            if (!StringUtils.isEmptyString(value)) {
                target = this.searchForKey(childRoot.getDocumentElement(), value);
                if (target == null) continue;
                pList = pe.getChildNodes();
                for (i = 0; i < pList.getLength(); ++i) {
                    tmpnode = childRoot.importNode(pList.item(i), false);
                    if (tmpnode.getNodeType() == 1 && this.searchForKey(target, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                    target.appendChild(tmpnode);
                }
                continue;
            }
            value = pe.getAttribute("keys");
            if (StringUtils.isEmptyString(value) || (target = this.searchForKey(childRoot.getDocumentElement(), value)) == null) continue;
            pList = target.getChildNodes();
            for (i = 0; i < pList.getLength(); ++i) {
                tmpnode = parentRoot.importNode(pList.item(i), false);
                if (tmpnode.getNodeType() == 1 && this.searchForKey(pe, ((Element)tmpnode).getAttribute("keys")) != null) continue;
                pe.appendChild(tmpnode);
            }
        }
    }

    private Element searchForKey(Element root, String key) {
        if (root == null || StringUtils.isEmptyString(key)) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(root);
        while (!queue.isEmpty()) {
            Element pe = (Element)queue.poll();
            NodeList pchildrenList = pe.getChildNodes();
            for (int i = 0; i < pchildrenList.getLength(); ++i) {
                Node node = pchildrenList.item(i);
                if (node.getNodeType() != 1) continue;
                queue.offer((Element)node);
            }
            String value = pe.getAttribute("class");
            if (StringUtils.isEmptyString(value) || !Constants.SUBJECTSCHEME_SUBJECTDEF.matches(value) || StringUtils.isEmptyString(value = pe.getAttribute("keys")) || !value.equals(key)) continue;
            return pe;
        }
        return null;
    }

    private void generateScheme(File filename, Document root) throws DITAOTException {
        try {
            this.job.getStore().writeDocument(root, filename.toURI());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new DITAOTException(e);
        }
    }

    public static File getPathtoProject(File currentFile, Job job) {
        File inputDir = URLUtils.toFile(job.getInputDir());
        File inputMap = URLUtils.toFile(job.getInputFile());
        if (job.getGeneratecopyouter() != Job.Generate.OLDSOLUTION) {
            return FileUtils.getRelativePath(currentFile, inputMap.getParentFile());
        }
        return FileUtils.getRelativePath(currentFile, inputDir);
    }

    private static String getRelativePathFromOut(File overflowingFile, Job job) {
        URI relativePath = URLUtils.getRelativePath(job.getInputFile(), overflowingFile.toURI());
        File outputDir = job.getOutputDir().getAbsoluteFile();
        File outputPathName = new File(outputDir, "index.html");
        File finalOutFilePathName = FileUtils.resolve(outputDir, relativePath.getPath());
        File finalRelativePathName = FileUtils.getRelativePath(finalOutFilePathName, outputPathName);
        File parentDir = finalRelativePathName.getParentFile();
        if (parentDir == null || parentDir.getPath().isEmpty()) {
            parentDir = new File(".");
        }
        return parentDir.getPath() + File.separator;
    }

    private static boolean isOutFile(File filePathName, File inputMap) {
        File relativePath = FileUtils.getRelativePath(inputMap.getAbsoluteFile(), filePathName.getAbsoluteFile());
        return relativePath.getPath().length() != 0 && relativePath.getPath().startsWith("..");
    }

    private static final class DTDForwardHandler
    implements LexicalHandler {
        private final XMLReader parser;

        public DTDForwardHandler(XMLReader parser) {
            this.parser = parser;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (publicId != null && !publicId.isEmpty()) {
                this.parser.getContentHandler().processingInstruction("doctype-public", publicId);
            }
            if (systemId != null && !systemId.isEmpty()) {
                this.parser.getContentHandler().processingInstruction("doctype-system", systemId);
            }
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }

    private static class TypeFilter
    extends AbstractXMLFilter {
        private DitaClass cls;

        private TypeFilter() {
        }

        private DitaClass getDitaClass() {
            return this.cls;
        }

        @Override
        public void startDocument() throws SAXException {
            this.cls = null;
            super.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.cls == null) {
                this.cls = DitaClass.getInstance(atts);
            }
            super.startElement(uri, localName, qName, atts);
        }
    }
}

